/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin.fakeskin;

import com.mojang.authlib.GameProfile;
import dev.lucaargolo.utils.client.misc.WebTextureHandler;
import dev.lucaargolo.utils.data.FakeSkinData;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class PlayerInfoMixin {
    @Shadow
    @Final
    private GameProfile profile;

    @Inject(at={@At(value="RETURN")}, method={"getSkin"}, cancellable=true)
    public void getSkin(CallbackInfoReturnable<PlayerSkin> cir) {
        PlayerSkin original = (PlayerSkin)cir.getReturnValue();
        FakeSkinData data = FakeSkinData.local();
        String link = data.getSkin(this.profile.getId());
        if (link != null) {
            cir.setReturnValue((Object)new PlayerSkin(WebTextureHandler.get(link, false).location(), null, null, null, original.model(), original.secure()));
        }
    }
}

