/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin.bookimages;

import dev.lucaargolo.utils.client.gui.widget.BookImageWidget;
import dev.lucaargolo.utils.mixed.bookimages.BookImageAccess;
import dev.lucaargolo.utils.mixed.bookimages.ImageBookScreen;
import dev.lucaargolo.utils.mixed.bookimages.SpreadImageBookScreen;
import io.github.mortuusars.scholar.client.gui.screen.SpreadBookScreen;
import io.github.mortuusars.scholar.client.gui.screen.view.BookViewAccess;
import io.github.mortuusars.scholar.client.gui.screen.view.SpreadBookViewScreen;
import java.util.UUID;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpreadBookViewScreen.class})
public abstract class ScholarBookViewScreenMixin
extends SpreadBookScreen
implements SpreadImageBookScreen {
    @Unique
    private final ImageBookScreen utils$leftScreen = new ImageBookScreen(){

        @Override
        public int utils$getCurrentPage() {
            return ScholarBookViewScreenMixin.this.currentSpread * 2;
        }

        @Override
        public Screen utils$getScreen() {
            return ScholarBookViewScreenMixin.this;
        }

        @Override
        public <T extends GuiEventListener & Renderable> void utils$addWidget(T widget) {
            ScholarBookViewScreenMixin.this.addRenderableWidget(widget);
        }

        @Override
        public void utils$removeWidget(GuiEventListener widget) {
            ScholarBookViewScreenMixin.this.removeWidget(widget);
        }

        @Override
        public void utils$modify() {
        }

        @Override
        public int utils$getWidgetTop() {
            return this.utils$getScreen().height / 2 - this.utils$getBookHeight() / 2 - 6;
        }

        @Override
        public int utils$getWidgetLeft() {
            return ImageBookScreen.super.utils$getWidgetLeft() - ImageBookScreen.super.utils$getBookWidth() / 2 - 8;
        }
    };
    @Unique
    private final ImageBookScreen utils$rightScreen = new ImageBookScreen(){

        @Override
        public int utils$getCurrentPage() {
            return ScholarBookViewScreenMixin.this.currentSpread * 2 + 1;
        }

        @Override
        public Screen utils$getScreen() {
            return ScholarBookViewScreenMixin.this;
        }

        @Override
        public <T extends GuiEventListener & Renderable> void utils$addWidget(T widget) {
            ScholarBookViewScreenMixin.this.addRenderableWidget(widget);
        }

        @Override
        public void utils$removeWidget(GuiEventListener widget) {
            ScholarBookViewScreenMixin.this.removeWidget(widget);
        }

        @Override
        public void utils$modify() {
        }

        @Override
        public int utils$getWidgetTop() {
            return this.utils$getScreen().height / 2 - this.utils$getBookHeight() / 2 - 6;
        }

        @Override
        public int utils$getWidgetLeft() {
            return ImageBookScreen.super.utils$getWidgetLeft() + ImageBookScreen.super.utils$getBookWidth() / 2 + 15;
        }
    };

    @Shadow
    public abstract BookViewAccess getBookAccess();

    public ScholarBookViewScreenMixin(int bookColor) {
        super(bookColor);
    }

    protected void createWidgets() {
        BookImageAccess imageAccess;
        ListTag imagesTag;
        BookViewAccess bookViewAccess = this.getBookAccess();
        if (bookViewAccess instanceof BookImageAccess && (imagesTag = (imageAccess = (BookImageAccess)bookViewAccess).utils$getImagesTag()) != null) {
            for (Tag innerTag : imagesTag) {
                if (!(innerTag instanceof CompoundTag)) continue;
                CompoundTag image = (CompoundTag)innerTag;
                int page = image.getInt("Page");
                int x = image.getInt("X");
                int y = image.getInt("Y");
                int width = image.getInt("Width");
                int height = image.getInt("Height");
                UUID uuid = image.getUUID("Image");
                BookImageWidget widget = new BookImageWidget(page % 2 == 0 ? this.utils$leftScreen : this.utils$rightScreen, page, x, y, width, height, uuid);
                this.addRenderableWidget((GuiEventListener)widget);
            }
        }
        super.createWidgets();
    }

    @Inject(at={@At(value="TAIL")}, method={"setBookAccess"})
    public void utils$resetView(BookViewAccess bookViewAccess, CallbackInfo ci) {
        this.repositionElements();
    }

    @Override
    public ImageBookScreen utils$getLeftScreen() {
        return this.utils$leftScreen;
    }

    @Override
    public ImageBookScreen utils$getRightScreen() {
        return this.utils$rightScreen;
    }

    @Override
    public boolean utils$isLeftScreenFocused() {
        return true;
    }
}

