/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin.bookimages;

import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import dev.lucaargolo.utils.client.gui.widget.ResizeableImageWidget;
import dev.lucaargolo.utils.data.ModDataComponentTypes;
import dev.lucaargolo.utils.mixed.bookimages.ImageBookScreen;
import dev.lucaargolo.utils.mixed.bookimages.SpreadImageBookScreen;
import dev.lucaargolo.utils.network.ServerboundBookImagePacket;
import dev.lucaargolo.utils.network.ServerboundBookImagesPacket;
import io.github.mortuusars.scholar.client.gui.screen.SpreadBookScreen;
import io.github.mortuusars.scholar.client.gui.screen.edit.SpreadBookEditScreen;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SpreadBookEditScreen.class})
public class ScholarBookEditScreenMixin
extends SpreadBookScreen
implements SpreadImageBookScreen {
    @Shadow
    protected boolean bookModified;
    @Shadow
    @Final
    protected ItemStack bookStack;
    @Shadow
    @Final
    protected List<String> pages;
    @Shadow
    @Final
    protected InteractionHand hand;
    @Shadow
    protected TextBox rightPageTextBox;
    @Unique
    private final ImageBookScreen utils$leftScreen = new ImageBookScreen(){

        @Override
        public int utils$getCurrentPage() {
            return ScholarBookEditScreenMixin.this.currentSpread * 2;
        }

        @Override
        public Screen utils$getScreen() {
            return ScholarBookEditScreenMixin.this;
        }

        @Override
        public <T extends GuiEventListener & Renderable> void utils$addWidget(T widget) {
            ScholarBookEditScreenMixin.this.renderables.addFirst((Renderable)widget);
            ScholarBookEditScreenMixin.this.children.addFirst(widget);
            ScholarBookEditScreenMixin.this.narratables.addFirst((NarratableEntry)widget);
        }

        @Override
        public void utils$removeWidget(GuiEventListener widget) {
            ScholarBookEditScreenMixin.this.removeWidget(widget);
        }

        @Override
        public void utils$modify() {
            ScholarBookEditScreenMixin.this.bookModified = true;
        }

        @Override
        public int utils$getWidgetTop() {
            return this.utils$getScreen().height / 2 - this.utils$getBookHeight() / 2 - 6;
        }

        @Override
        public int utils$getWidgetLeft() {
            return ImageBookScreen.super.utils$getWidgetLeft() - ImageBookScreen.super.utils$getBookWidth() / 2 - 8;
        }
    };
    @Unique
    private final ImageBookScreen utils$rightScreen = new ImageBookScreen(){

        @Override
        public int utils$getCurrentPage() {
            return ScholarBookEditScreenMixin.this.currentSpread * 2 + 1;
        }

        @Override
        public Screen utils$getScreen() {
            return ScholarBookEditScreenMixin.this;
        }

        @Override
        public <T extends GuiEventListener & Renderable> void utils$addWidget(T widget) {
            ScholarBookEditScreenMixin.this.renderables.addFirst((Renderable)widget);
            ScholarBookEditScreenMixin.this.children.addFirst(widget);
            ScholarBookEditScreenMixin.this.narratables.addFirst((NarratableEntry)widget);
        }

        @Override
        public void utils$removeWidget(GuiEventListener widget) {
            ScholarBookEditScreenMixin.this.removeWidget(widget);
        }

        @Override
        public void utils$modify() {
            ScholarBookEditScreenMixin.this.bookModified = true;
        }

        @Override
        public int utils$getWidgetTop() {
            return this.utils$getScreen().height / 2 - this.utils$getBookHeight() / 2 - 6;
        }

        @Override
        public int utils$getWidgetLeft() {
            return ImageBookScreen.super.utils$getWidgetLeft() + ImageBookScreen.super.utils$getBookWidth() / 2 + 15;
        }
    };
    @Unique
    private int utils$maxPage = Integer.MIN_VALUE;

    public ScholarBookEditScreenMixin(int bookColor) {
        super(bookColor);
    }

    @Inject(at={@At(value="HEAD")}, method={"createWidgets"})
    public void utils$addImageWidgets(CallbackInfo ci) {
        ListTag imagesTag = (ListTag)this.bookStack.get(ModDataComponentTypes.BOOK_IMAGES);
        if (imagesTag != null) {
            for (Tag innerTag : imagesTag) {
                if (!(innerTag instanceof CompoundTag)) continue;
                CompoundTag image = (CompoundTag)innerTag;
                int page = image.getInt("Page");
                int x = image.getInt("X");
                int y = image.getInt("Y");
                int width = image.getInt("Width");
                int height = image.getInt("Height");
                UUID uuid = image.getUUID("Image");
                ResizeableImageWidget widget = new ResizeableImageWidget(page % 2 == 0 ? this.utils$leftScreen : this.utils$rightScreen, page, x, y, width, height, uuid);
                this.addRenderableWidget((GuiEventListener)widget);
                if (page <= this.utils$maxPage) continue;
                this.utils$maxPage = page;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setupPages"}, cancellable=true)
    public void utils$afterSetupPages(ItemStack bookStack, CallbackInfo ci) {
        for (int i = 0; i < this.utils$maxPage + 1; ++i) {
            if (this.utils$maxPage < this.pages.size()) continue;
            this.pages.add("");
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed"}, cancellable=true)
    public void utils$handleClipboardImage(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (pKeyCode == 86 && pModifiers == 2) {
            try {
                BufferedImage img = null;
                Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (content == null) {
                    System.out.println("error: nothing found in clipboard");
                } else if (content.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    img = (BufferedImage)content.getTransferData(DataFlavor.imageFlavor);
                } else if (content.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List fileList = (List)content.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : fileList) {
                        if (!ScholarBookEditScreenMixin.utils$isImageFile(file)) continue;
                        try {
                            img = ImageIO.read(file);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (img != null) {
                    if (((Boolean)Main.SERVER_CONFIG.allowImageUpload.get()).booleanValue()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundBookImagePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        UUID uuid = UUID.randomUUID();
                        ClientImageUploadManager.addImage((UUID)uuid, (BufferedImage)img);
                        PacketDistributor.sendToServer((CustomPacketPayload)new MessageRequestUploadCustomImage(uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    cir.setReturnValue((Object)true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateLocalCopy"})
    public void utils$saveImages(CallbackInfo ci) {
        ListTag imagesList = new ListTag();
        List children = this.children();
        for (GuiEventListener child : children) {
            if (!(child instanceof ResizeableImageWidget)) continue;
            ResizeableImageWidget widget = (ResizeableImageWidget)child;
            CompoundTag image = new CompoundTag();
            image.putInt("Page", widget.getPage());
            image.putInt("X", widget.getX());
            image.putInt("Y", widget.getY());
            image.putInt("Width", widget.getWidth());
            image.putInt("Height", widget.getHeight());
            image.putUUID("Image", widget.getImage());
            imagesList.add((Object)image);
        }
        if (!imagesList.isEmpty()) {
            this.bookStack.set(ModDataComponentTypes.BOOK_IMAGES, (Object)imagesList);
        } else {
            this.bookStack.remove(ModDataComponentTypes.BOOK_IMAGES);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lio/github/mortuusars/scholar/client/gui/screen/edit/SpreadBookEditScreen;sendChanges(Ljava/lang/String;)V")}, method={"saveChanges"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void utils$sendImages(boolean sign, String title, CallbackInfo ci) {
        ListTag imagesList = (ListTag)this.bookStack.get(ModDataComponentTypes.BOOK_IMAGES);
        if (imagesList == null) {
            imagesList = new ListTag();
        }
        int i = this.hand == InteractionHand.MAIN_HAND ? this.player.getInventory().selected : 40;
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundBookImagesPacket(i, imagesList), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Unique
    private static boolean utils$isImageFile(File file) {
        String[] imageExtensions = new String[]{"jpg", "jpeg", "png", "gif", "bmp"};
        String fileName = file.getName().toLowerCase();
        for (String extension : imageExtensions) {
            if (!fileName.endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImageBookScreen utils$getLeftScreen() {
        return this.utils$leftScreen;
    }

    @Override
    public ImageBookScreen utils$getRightScreen() {
        return this.utils$rightScreen;
    }

    @Override
    public boolean utils$isLeftScreenFocused() {
        return this.getFocused() != this.rightPageTextBox;
    }
}

