/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin.bookimages;

import dev.lucaargolo.utils.data.ModDataComponentTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LecternBlockEntity.class})
public class LecternBlockEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"getPageCount"}, cancellable=true)
    private static void getPageCount(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        ListTag imagesTag = (ListTag)stack.get(ModDataComponentTypes.BOOK_IMAGES);
        int maxPage = Integer.MIN_VALUE;
        if (imagesTag != null) {
            for (Tag innerTag : imagesTag) {
                CompoundTag image;
                int page;
                if (!(innerTag instanceof CompoundTag) || (page = (image = (CompoundTag)innerTag).getInt("Page")) <= maxPage) continue;
                maxPage = page;
            }
        }
        cir.setReturnValue((Object)Math.max((Integer)cir.getReturnValue(), maxPage + 1));
    }
}

