/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin.bookimages;

import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import dev.lucaargolo.utils.client.gui.widget.ResizeableImageWidget;
import dev.lucaargolo.utils.data.ModDataComponentTypes;
import dev.lucaargolo.utils.mixed.bookimages.ImageBookScreen;
import dev.lucaargolo.utils.network.ServerboundBookImagePacket;
import dev.lucaargolo.utils.network.ServerboundBookImagesPacket;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BookEditScreen.class})
public class BookEditScreenMixin
extends Screen
implements ImageBookScreen {
    @Shadow
    private int currentPage;
    @Shadow
    @Final
    private ItemStack book;
    @Shadow
    private boolean isModified;
    @Shadow
    private boolean isSigning;
    @Shadow
    @Final
    private List<String> pages;
    @Shadow
    @Final
    private InteractionHand hand;
    @Shadow
    @Final
    private Player owner;

    protected BookEditScreenMixin(Component pTitle) {
        super(pTitle);
    }

    @Inject(at={@At(value="TAIL")}, method={"init"})
    public void utils$addImageWidgets(CallbackInfo ci) {
        ListTag imagesTag = (ListTag)this.book.get(ModDataComponentTypes.BOOK_IMAGES);
        if (imagesTag != null) {
            int maxPage = Integer.MIN_VALUE;
            for (Tag innerTag : imagesTag) {
                if (!(innerTag instanceof CompoundTag)) continue;
                CompoundTag image = (CompoundTag)innerTag;
                int page = image.getInt("Page");
                int x = image.getInt("X");
                int y = image.getInt("Y");
                int width = image.getInt("Width");
                int height = image.getInt("Height");
                UUID uuid = image.getUUID("Image");
                ResizeableImageWidget widget = new ResizeableImageWidget(this, page, x, y, width, height, uuid);
                this.addRenderableWidget((GuiEventListener)widget);
                if (page <= maxPage) continue;
                maxPage = page;
            }
            for (int i = 0; i < maxPage + 1; ++i) {
                if (maxPage < this.pages.size()) continue;
                this.pages.add("");
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed"}, cancellable=true)
    public void utils$handleClipboardImage(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (pKeyCode == 86 && pModifiers == 2) {
            assert (this.minecraft != null);
            try {
                BufferedImage img = null;
                Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (content == null) {
                    System.out.println("error: nothing found in clipboard");
                } else if (content.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    img = (BufferedImage)content.getTransferData(DataFlavor.imageFlavor);
                } else if (content.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List fileList = (List)content.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : fileList) {
                        if (!BookEditScreenMixin.utils$isImageFile(file)) continue;
                        try {
                            img = ImageIO.read(file);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (img != null) {
                    if (((Boolean)Main.SERVER_CONFIG.allowImageUpload.get()).booleanValue()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundBookImagePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        UUID uuid = UUID.randomUUID();
                        ClientImageUploadManager.addImage((UUID)uuid, (BufferedImage)img);
                        PacketDistributor.sendToServer((CustomPacketPayload)new MessageRequestUploadCustomImage(uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    cir.setReturnValue((Object)true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateLocalCopy"})
    public void utils$saveImages(CallbackInfo ci) {
        ListTag imagesList = new ListTag();
        List children = this.children();
        for (GuiEventListener child : children) {
            if (!(child instanceof ResizeableImageWidget)) continue;
            ResizeableImageWidget widget = (ResizeableImageWidget)child;
            CompoundTag image = new CompoundTag();
            image.putInt("Page", widget.getPage());
            image.putInt("X", widget.getX());
            image.putInt("Y", widget.getY());
            image.putInt("Width", widget.getWidth());
            image.putInt("Height", widget.getHeight());
            image.putUUID("Image", widget.getImage());
            imagesList.add((Object)image);
        }
        if (!imagesList.isEmpty()) {
            this.book.set(ModDataComponentTypes.BOOK_IMAGES, (Object)imagesList);
        } else {
            this.book.remove(ModDataComponentTypes.BOOK_IMAGES);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V")}, method={"saveChanges"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void utils$sendImages(boolean pPublish, CallbackInfo ci) {
        ListTag imagesList = (ListTag)this.book.get(ModDataComponentTypes.BOOK_IMAGES);
        if (imagesList == null) {
            imagesList = new ListTag();
        }
        int i = this.hand == InteractionHand.MAIN_HAND ? this.owner.getInventory().selected : 40;
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundBookImagesPacket(i, imagesList), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Unique
    private static boolean utils$isImageFile(File file) {
        String[] imageExtensions = new String[]{"jpg", "jpeg", "png", "gif", "bmp"};
        String fileName = file.getName().toLowerCase();
        for (String extension : imageExtensions) {
            if (!fileName.endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int utils$getCurrentPage() {
        return this.isSigning ? -1 : this.currentPage;
    }

    @Override
    public Screen utils$getScreen() {
        return this;
    }

    @Override
    public <T extends GuiEventListener & Renderable> void utils$addWidget(T widget) {
        this.addRenderableWidget(widget);
    }

    @Override
    public void utils$removeWidget(GuiEventListener widget) {
        this.removeWidget(widget);
    }

    @Override
    public void utils$modify() {
        this.isModified = true;
    }
}

