/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ShaderInstance.class})
public abstract class ShaderInstanceMixin {
    @Shadow
    @Final
    static Logger LOGGER;
    @Shadow
    @Final
    private String name;
    @Shadow
    @Final
    private int programId;
    @Unique
    private Map<String, Object> darkUtils$cubeSamplerMap;
    @Unique
    private List<String> darkUtils$cubeSamplerNames;
    @Unique
    private List<Integer> darkUtils$cubeSamplerLocations;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/util/GsonHelper;getAsString(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/String;", ordinal=0)}, method={"<init>(Lnet/minecraft/server/packs/resources/ResourceProvider;Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;)V"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void initCubeSamplers(ResourceProvider p_173336_, ResourceLocation shaderLocation, VertexFormat p_173338_, CallbackInfo ci, ResourceLocation resourcelocation, Reader reader, JsonObject jsonobject) throws ChainedJsonException {
        this.darkUtils$cubeSamplerMap = Maps.newHashMap();
        this.darkUtils$cubeSamplerNames = Lists.newArrayList();
        this.darkUtils$cubeSamplerLocations = Lists.newArrayList();
        JsonArray jsonarray = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"cube_samplers", null);
        if (jsonarray != null) {
            int i = 0;
            for (JsonElement jsonelement : jsonarray) {
                try {
                    this.darkUtils$parseSamplerCubeNode(jsonelement);
                }
                catch (Exception exception1) {
                    ChainedJsonException chainedjsonexception1 = ChainedJsonException.forException((Exception)exception1);
                    chainedjsonexception1.prependJsonKey("cubeSamplers[" + i + "]");
                    throw chainedjsonexception1;
                }
                ++i;
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;size()I")}, method={"clear"})
    public void clearCubeSamplers(CallbackInfo ci) {
        for (int j = 0; j < this.darkUtils$cubeSamplerLocations.size(); ++j) {
            if (this.darkUtils$cubeSamplerMap.get(this.darkUtils$cubeSamplerNames.get(j)) == null) continue;
            GL13.glActiveTexture((int)(33984 + j));
            GL11.glBindTexture((int)34067, (int)0);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;size()I")}, method={"apply"})
    public void applyCubeSamplers(CallbackInfo ci) {
        for (int samplerId = 0; samplerId < this.darkUtils$cubeSamplerLocations.size(); ++samplerId) {
            String samplerName = this.darkUtils$cubeSamplerNames.get(samplerId);
            if (this.darkUtils$cubeSamplerMap.get(samplerName) == null) continue;
            int uniformId = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)samplerName);
            Uniform.uploadInteger((int)uniformId, (int)samplerId);
            GL13.glActiveTexture((int)(33984 + samplerId));
            Object object = this.darkUtils$cubeSamplerMap.get(samplerName);
            int glId = -1;
            if (object instanceof RenderTarget) {
                RenderTarget target = (RenderTarget)object;
                glId = target.getColorTextureId();
            } else if (object instanceof AbstractTexture) {
                AbstractTexture texture = (AbstractTexture)object;
                glId = texture.getId();
            } else if (object instanceof Integer) {
                Integer integer = (Integer)object;
                glId = integer;
            }
            if (glId == -1) continue;
            GL11.glBindTexture((int)34067, (int)glId);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Ljava/util/List;size()I")}, method={"updateLocations"})
    public void updateCubeSamplerLocations(CallbackInfo ci) {
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < this.darkUtils$cubeSamplerNames.size(); ++i) {
            String s = this.darkUtils$cubeSamplerNames.get(i);
            int j = Uniform.glGetUniformLocation((int)this.programId, (CharSequence)s);
            if (j == -1) {
                LOGGER.warn("Shader {} could not find cube sampler named {} in the specified shader program.", (Object)this.name, (Object)s);
                this.darkUtils$cubeSamplerMap.remove(s);
                intlist.add(i);
                continue;
            }
            this.darkUtils$cubeSamplerLocations.add(j);
        }
        for (int l = intlist.size() - 1; l >= 0; --l) {
            int i1 = intlist.getInt(l);
            this.darkUtils$cubeSamplerNames.remove(i1);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setDefaultUniforms"})
    public void setCubeSamplerDefaultUniforms(CallbackInfo ci) {
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            this.darkUtils$setCubeSampler("SamplerCube" + i, j);
        }
    }

    @Unique
    public void darkUtils$parseSamplerCubeNode(JsonElement json) {
        JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)json, (String)"cube_sampler");
        String s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"name");
        if (!GsonHelper.isStringValue((JsonObject)jsonobject, (String)"file")) {
            this.darkUtils$cubeSamplerMap.put(s, null);
            this.darkUtils$cubeSamplerNames.add(s);
        } else {
            this.darkUtils$cubeSamplerNames.add(s);
        }
    }

    @Unique
    public void darkUtils$setCubeSampler(String name, Object textureId) {
        this.darkUtils$cubeSamplerMap.put(name, textureId);
        this.markDirty();
    }

    @Shadow
    public abstract void markDirty();
}

