/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Gui.class})
public class GuiMixin {
    @Shadow
    @Nullable
    private Component overlayMessageString;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;width(Lnet/minecraft/network/chat/FormattedText;)I")}, method={"renderOverlayMessage"}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    public void utils$MultilineActionBar(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci, Font font, float f, int opacity, int yShift, int color) {
        String rawString;
        if (this.overlayMessageString != null && (rawString = this.overlayMessageString.getString()).contains("\n")) {
            ArrayList<Component> siblings = new ArrayList<Component>();
            siblings.add((Component)this.overlayMessageString.plainCopy().withStyle(this.overlayMessageString.getStyle()));
            GuiMixin.utils$collectSiblings(siblings, this.overlayMessageString);
            ArrayDeque<List<Component>> queue = new ArrayDeque<List<Component>>();
            for (Component sibling : siblings) {
                GuiMixin.utils$computeMultiline(queue, sibling);
            }
            int l = queue.size() - 1;
            int i = 0;
            while (!queue.isEmpty()) {
                MutableComponent newOverlayMessageString = Component.empty();
                List lineSiblings = (List)queue.removeFirst();
                for (Component lineSibling : lineSiblings) {
                    newOverlayMessageString.append(lineSibling);
                }
                int messageWidth = font.width((FormattedText)newOverlayMessageString);
                guiGraphics.drawStringWithBackdrop(font, (Component)newOverlayMessageString, -messageWidth / 2, -4 - 10 * l + 10 * i, 0, color | opacity << 24);
                ++i;
            }
            RenderSystem.disableBlend();
            guiGraphics.pose().popPose();
            this.minecraft.getProfiler().pop();
            ci.cancel();
        }
    }

    @Unique
    private static void utils$collectSiblings(List<Component> all, Component component) {
        List siblings = component.getSiblings();
        for (Component sibling : siblings) {
            all.add((Component)sibling.plainCopy().withStyle(sibling.getStyle()));
            GuiMixin.utils$collectSiblings(all, sibling);
        }
    }

    @Unique
    private static void utils$computeMultiline(Deque<List<Component>> queue, Component component) {
        String rawString = component.getString();
        if (rawString.contains("\n")) {
            String[] rawStrings = rawString.split("\n");
            if (rawStrings.length == 0) {
                queue.addLast(new ArrayList());
            } else {
                int i = 0;
                if (queue.isEmpty()) {
                    queue.addLast(new ArrayList());
                }
                for (String string : rawStrings) {
                    queue.getLast().add((Component)Component.literal((String)string).withStyle(component.getStyle()));
                    if (++i >= rawStrings.length) continue;
                    queue.addLast(new ArrayList());
                }
            }
        } else {
            if (queue.isEmpty()) {
                queue.addLast(new ArrayList());
            }
            queue.getLast().add(component);
        }
    }
}

