/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import dev.lucaargolo.utils.mixed.DynamicTextureMixed;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DynamicTexture.class})
public abstract class DynamicTextureMixin
extends AbstractTexture
implements Dumpable,
DynamicTextureMixed {
    @Shadow
    private NativeImage pixels;

    @Shadow
    public abstract void upload();

    @Redirect(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/TextureUtil;prepareImage(III)V"), method={"<init>(Lcom/mojang/blaze3d/platform/NativeImage;)V"})
    public void onInit(int textureId, int width, int height) {
        if (this.darkUtils$isFiltered()) {
            TextureUtil.prepareImage((int)textureId, (int)8, (int)width, (int)height);
        } else {
            TextureUtil.prepareImage((int)textureId, (int)width, (int)height);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/TextureUtil;prepareImage(III)V"), method={"<init>(IIZ)V"})
    public void onAlternateInit(int textureId, int width, int height) {
        if (this.darkUtils$isFiltered()) {
            TextureUtil.prepareImage((int)textureId, (int)8, (int)width, (int)height);
        } else {
            TextureUtil.prepareImage((int)textureId, (int)width, (int)height);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/TextureUtil;prepareImage(III)V")}, method={"lambda$new$0"}, cancellable=true)
    public void onOffThreadInit(CallbackInfo ci) {
        if (this.darkUtils$isFiltered()) {
            TextureUtil.prepareImage((int)this.getId(), (int)8, (int)this.pixels.getWidth(), (int)this.pixels.getHeight());
            this.upload();
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"upload"}, cancellable=true)
    public void uploadFiltered(CallbackInfo ci) {
        if (this.darkUtils$isFiltered() && this.pixels != null) {
            this.bind();
            this.pixels.upload(0, 0, 0, 0, 0, this.pixels.getWidth(), this.pixels.getHeight(), true, true, true, true);
            GL30.glGenerateMipmap((int)3553);
            if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
                float maxLevel = GL11.glGetFloat((int)34047);
                float level = Math.min(maxLevel, 16.0f);
                GL11.glTexParameterf((int)3553, (int)34046, (float)level);
            }
            ci.cancel();
        }
    }

    @Override
    public boolean darkUtils$isFiltered() {
        return false;
    }
}

