/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.misc;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audio.AudioConverter;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.plugins.impl.PositionImpl;
import de.maxhenkel.voicechat.plugins.impl.ServerLevelImpl;
import dev.lucaargolo.utils.Arkanis;
import dev.lucaargolo.utils.data.SoundboardData;
import dev.lucaargolo.utils.mixin.voicechat.LocationalAudioChannelImplAccessor;
import dev.lucaargolo.utils.network.ClientboundSoundboardPacket;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import net.minecraft.ChatFormatting;
import net.minecraft.client.sounds.JOrbisAudioStream;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.PacketDistributor;
import net.sourceforge.jaad.spi.javasound.AACAudioFileReader;
import net.sourceforge.jaad.spi.javasound.AACAudioFormat;
import net.sourceforge.jaad.spi.javasound.AACFormatConversionProvider;
import org.jetbrains.annotations.Nullable;

@ForgeVoicechatPlugin
public class SoundBoard
implements VoicechatPlugin {
    @Nullable
    private static VoicechatServerApi API = null;
    public static final Map<UUID, Map<String, LocationalAudioChannel>> CHANNELS = new HashMap<UUID, Map<String, LocationalAudioChannel>>();
    public static final Map<LocationalAudioChannel, AudioPlayer> PLAYERS = new HashMap<LocationalAudioChannel, AudioPlayer>();
    private static final String SOUNDS_PATH = String.valueOf(FMLPaths.GAMEDIR.get()) + File.separator + "sounds";
    private static final Set<UUID> UPDATED_PLAYERS = new HashSet<UUID>();
    private static final ConcurrentHashMap<String, Object> SOUNDS = new ConcurrentHashMap();
    private static final AtomicBoolean SOUNDS_UPDATED = new AtomicBoolean();
    private static final ConcurrentHashMap<UUID, Boolean> processingPlayers = new ConcurrentHashMap();

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        API = event.getVoicechat();
        SoundBoard.updateSounds();
    }

    public String getPluginId() {
        return "soundboard";
    }

    private static boolean isAcceptedFile(String fileName) {
        return fileName.endsWith(".mp3") || fileName.endsWith(".wav") || fileName.endsWith(".ogg");
    }

    private static void walkThroughDirectory(File folder, ConcurrentHashMap<String, Object> map) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (file.isFile() && SoundBoard.isAcceptedFile(name)) {
                    map.put(name, name);
                    continue;
                }
                if (!file.isDirectory()) continue;
                ConcurrentHashMap<String, Object> innerMap = new ConcurrentHashMap<String, Object>();
                SoundBoard.walkThroughDirectory(file, innerMap);
                map.put(name, innerMap);
            }
        }
    }

    public static void updateSounds() {
        SOUNDS.clear();
        File directory = new File(SOUNDS_PATH);
        if (directory.exists()) {
            SoundBoard.walkThroughDirectory(directory, SOUNDS);
        }
        SOUNDS_UPDATED.set(true);
    }

    public static void playSound(ServerPlayer player, String file) {
        if (API == null) {
            Arkanis.sendMessage(player, (Component)Component.literal((String)"The voice chat is not setup!").withStyle(ChatFormatting.RED), new ChatFormatting[0]);
            return;
        }
        UUID playerId = player.getUUID();
        if (processingPlayers.putIfAbsent(playerId, Boolean.TRUE) != null) {
            Arkanis.sendMessage(player, (Component)Component.literal((String)"Please wait before playing another audio.").withStyle(ChatFormatting.RED), new ChatFormatting[0]);
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return SoundBoard.readFile(API.getAudioConverter(), SOUNDS_PATH + File.separator + file);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                throw new CompletionException(e);
            }
        }).thenAcceptAsync(sound -> player.server.execute(() -> {
            Map playerChannels = CHANNELS.computeIfAbsent(playerId, u -> new HashMap());
            LocationalAudioChannel channel = playerChannels.computeIfAbsent(file, i -> API.createLocationalAudioChannel(UUID.randomUUID(), (ServerLevel)new ServerLevelImpl(player.serverLevel()), (Position)new PositionImpl(player.position())));
            AudioPlayer oldPlayer = PLAYERS.remove(channel);
            if (oldPlayer != null) {
                oldPlayer.stopPlaying();
            } else {
                AudioPlayer newPlayer = PLAYERS.computeIfAbsent(channel, c -> API.createAudioPlayer((AudioChannel)channel, API.createEncoder(), sound));
                newPlayer.setOnStopped(() -> {
                    PLAYERS.remove(channel);
                    UPDATED_PLAYERS.add(playerId);
                });
                newPlayer.startPlaying();
            }
            UPDATED_PLAYERS.add(playerId);
        }))).whenComplete((result, ex) -> {
            processingPlayers.remove(playerId);
            if (ex != null) {
                Arkanis.sendMessage(player, (Component)Component.literal((String)"Error processing audio."), ChatFormatting.RED);
            }
        });
    }

    public static void tick(MinecraftServer server) {
        Iterator<Map.Entry<UUID, Map<String, LocationalAudioChannel>>> iterator = CHANNELS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Map<String, LocationalAudioChannel>> entry = iterator.next();
            ServerPlayer player = server.getPlayerList().getPlayer(entry.getKey());
            if (player == null) {
                entry.getValue().forEach((file, channel) -> {
                    AudioPlayer oldPlayer = PLAYERS.remove(channel);
                    if (oldPlayer != null) {
                        oldPlayer.stopPlaying();
                    }
                });
                iterator.remove();
                continue;
            }
            entry.getValue().forEach((file, channel) -> {
                channel.updateLocation((Position)new PositionImpl(player.position()));
                if (channel instanceof LocationalAudioChannelImplAccessor) {
                    LocationalAudioChannelImplAccessor accessor = (LocationalAudioChannelImplAccessor)channel;
                    accessor.setLevel((ServerLevel)new ServerLevelImpl(player.serverLevel()));
                }
            });
        }
        if (SOUNDS_UPDATED.get()) {
            SOUNDS_UPDATED.set(false);
            server.getPlayerList().getPlayers().forEach(SoundBoard::updatePlayer);
        }
    }

    public static void tickPlayer(ServerPlayer serverPlayer) {
        UUID uuid = serverPlayer.getUUID();
        if (UPDATED_PLAYERS.remove(uuid)) {
            SoundBoard.updatePlayer(serverPlayer);
        }
    }

    public static void updatePlayer(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        if (player.hasPermissions(2)) {
            Map playerChannels = CHANNELS.computeIfAbsent(player.getUUID(), u -> new HashMap());
            List<String> playingSounds = playerChannels.entrySet().stream().filter(e -> PLAYERS.containsKey(e.getValue())).map(Map.Entry::getKey).toList();
            List<String> favoriteSounds = SoundboardData.get(server).getFavoriteSounds(player);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundSoundboardPacket(File.separatorChar, SOUNDS, playingSounds, favoriteSounds), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static short[] readFile(AudioConverter converter, String filePath) throws UnsupportedAudioFileException, IOException {
        AudioInputStream sourceInputStream = SoundBoard.getAudioInputStreamManual(new File(filePath));
        AudioFormat sourceFormat = sourceInputStream.getFormat();
        AudioFormat convertedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), 2 * sourceFormat.getChannels(), sourceFormat.getSampleRate(), sourceFormat instanceof AACAudioFormat && sourceFormat.isBigEndian());
        AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, sourceFormat.getChannels(), 2 * sourceFormat.getChannels(), 48000.0f, false);
        AudioInputStream convertedInputStream = SoundBoard.getAudioInputStreamManual(convertedFormat, sourceInputStream);
        AudioInputStream finalInputStream = convertedFormat.getSampleRate() != 48000.0f ? AudioSystem.getAudioInputStream(targetFormat, convertedInputStream) : convertedInputStream;
        byte[] audioData = finalInputStream.readAllBytes();
        int numChannels = finalInputStream.getFormat().getChannels();
        int samplesPerChannel = audioData.length / (numChannels * 2);
        byte[] monoData = new byte[samplesPerChannel * 2];
        for (int i = 0; i < samplesPerChannel; ++i) {
            int sum = 0;
            for (int j = 0; j < numChannels; ++j) {
                int pos = (i * numChannels + j) * 2;
                short sample = (short)(audioData[pos] & 0xFF | audioData[pos + 1] << 8);
                sum += sample;
            }
            short avgSample = (short)(sum / numChannels);
            monoData[i * 2] = (byte)(avgSample & 0xFF);
            monoData[i * 2 + 1] = (byte)(avgSample >> 8 & 0xFF);
        }
        return converter.bytesToShorts(monoData);
    }

    public static AudioInputStream getAudioInputStreamManual(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioInputStream targetInputStream;
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (sourceFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            MpegFormatConversionProvider mpegCodec = new MpegFormatConversionProvider();
            AACFormatConversionProvider aacCodec = new AACFormatConversionProvider();
            targetInputStream = mpegCodec.isConversionSupported(targetFormat, sourceFormat) ? mpegCodec.getAudioInputStream(targetFormat, sourceStream) : (aacCodec.isConversionSupported(targetFormat, sourceFormat) ? aacCodec.getAudioInputStream(targetFormat, sourceStream) : AudioSystem.getAudioInputStream(targetFormat, sourceStream));
        } else {
            targetInputStream = sourceStream;
        }
        return targetInputStream;
    }

    public static AudioInputStream getAudioInputStreamManual(File file) throws UnsupportedAudioFileException, IOException {
        AudioInputStream sourceInputStream;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            if (!file.getName().endsWith(".ogg")) {
                throw new UnsupportedAudioFileException("Not ogg file");
            }
            JOrbisAudioStream oggStream = new JOrbisAudioStream((InputStream)inputStream);
            ByteBuffer buffer = oggStream.readAll();
            ByteBufferBackedInputStream stream = new ByteBufferBackedInputStream(buffer);
            AudioFormat format = oggStream.getFormat();
            sourceInputStream = new AudioInputStream((InputStream)stream, format, buffer.capacity() / format.getFrameSize());
        }
        catch (Exception ignored) {
            MpegAudioFileReader mpegReader = new MpegAudioFileReader();
            AACAudioFileReader aacReader = new AACAudioFileReader();
            try {
                sourceInputStream = mpegReader.getAudioInputStream(file);
            }
            catch (UnsupportedAudioFileException ignored1) {
                try {
                    sourceInputStream = aacReader.getAudioInputStream(file);
                }
                catch (UnsupportedAudioFileException ignored2) {
                    sourceInputStream = AudioSystem.getAudioInputStream(file);
                }
            }
        }
        return sourceInputStream;
    }
}

