/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.menu;

import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.utils.menu.ModMenus;
import java.util.UUID;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvSeeMenu
extends AbstractContainerMenu {
    private final Player player;
    private final Container playerContainer;
    private final Container playerCosmeticContainer;
    @Nullable
    private final Player otherPlayer;
    private final Container otherPlayerContainer;
    private final Container otherPlayerCosmeticContainer;

    public InvSeeMenu(int containerId, Inventory playerInventory, UUID otherPlayer, @Nullable Inventory otherPlayerInventory) {
        super((MenuType)ModMenus.INV_SEE.get(), containerId);
        Level level = playerInventory.player.level();
        this.player = playerInventory.player;
        this.playerContainer = playerInventory;
        CAStacksBase playerCAStacks = !level.isClientSide() ? CosArmorAPI.getCAStacks((UUID)this.player.getUUID()) : null;
        this.playerCosmeticContainer = playerCAStacks instanceof InventoryCosArmor ? (InventoryCosArmor)playerCAStacks : new SimpleContainer(4);
        this.otherPlayer = otherPlayerInventory != null ? otherPlayerInventory.player : this.player.level().getPlayerByUUID(otherPlayer);
        this.otherPlayerContainer = otherPlayerInventory != null ? otherPlayerInventory : new SimpleContainer(playerInventory.getContainerSize());
        CAStacksBase otherPlayerCAStacks = !level.isClientSide() ? CosArmorAPI.getCAStacks((UUID)otherPlayer) : null;
        this.otherPlayerCosmeticContainer = otherPlayerCAStacks instanceof InventoryCosArmor ? (InventoryCosArmor)otherPlayerCAStacks : new SimpleContainer(4);
        this.addPlayerSlots(this.playerContainer, this.playerCosmeticContainer, this.player, 0);
        this.addPlayerSlots(this.otherPlayerContainer, this.otherPlayerCosmeticContainer, this.otherPlayer, 180);
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Player getOtherPlayer() {
        return this.otherPlayer;
    }

    private void addPlayerSlots(Container container, Container cosmeticContainer, final @Nullable Player player, int xOffset) {
        ResourceLocation resourcelocation;
        int k;
        for (k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = InventoryMenu.SLOT_IDS[k];
            resourcelocation = (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(equipmentslot);
            this.addSlot(new Slot(container, 39 - k, xOffset + 8, 8 + k * 18){

                public void setByPlayer(@NotNull ItemStack pNewStack, @NotNull ItemStack pOldStack) {
                    if (player != null) {
                        player.onEquipItem(equipmentslot, pOldStack, pNewStack);
                    }
                    super.setByPlayer(pNewStack, pOldStack);
                }

                @Nullable
                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return resourcelocation != null ? Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)resourcelocation) : super.getNoItemIcon();
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return stack.canEquip(equipmentslot, (LivingEntity)(player != null ? player : InvSeeMenu.this.player));
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot(container, j1 + (l + 1) * 9, xOffset + 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot(container, i1, xOffset + 8 + i1 * 18, 142));
        }
        this.addSlot(new Slot(this, container, 40, xOffset + 77, 62){

            public void setByPlayer(@NotNull ItemStack newStack, @NotNull ItemStack oldStack) {
                if (player != null) {
                    player.onEquipItem(EquipmentSlot.OFFHAND, oldStack, newStack);
                }
                super.setByPlayer(newStack, oldStack);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        for (k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = InventoryMenu.SLOT_IDS[k];
            resourcelocation = (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(equipmentslot);
            this.addSlot(new Slot(cosmeticContainer, 3 - k, xOffset + 98 + k * 18, 62){

                @Nullable
                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return resourcelocation != null ? Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)resourcelocation) : super.getNoItemIcon();
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return stack.canEquip(equipmentslot, (LivingEntity)(player != null ? player : InvSeeMenu.this.player));
                }
            });
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

