/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class SoundboardData
extends SavedData {
    public static final String NAME = "SoundboardData";
    private final HashMap<UUID, List<String>> favoriteSounds = new HashMap();
    public static final SavedData.Factory<SoundboardData> FACTORY = new SavedData.Factory(SoundboardData::new, SoundboardData::create, null);

    @NotNull
    public CompoundTag save(@NotNull CompoundTag pCompoundTag, @NotNull HolderLookup.Provider registries) {
        ListTag favoriteSoundsTag = new ListTag();
        for (UUID uuid : this.favoriteSounds.keySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.putUUID("PlayerUUID", uuid);
            List<String> sounds = this.favoriteSounds.get(uuid);
            ListTag soundsListTag = new ListTag();
            for (String sound : sounds) {
                soundsListTag.add((Object)StringTag.valueOf((String)sound));
            }
            playerTag.put("FavoriteSounds", (Tag)soundsListTag);
            favoriteSoundsTag.add((Object)playerTag);
        }
        pCompoundTag.put("FavoriteSounds", (Tag)favoriteSoundsTag);
        return pCompoundTag;
    }

    @NotNull
    public static SoundboardData create(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registries) {
        SoundboardData data = new SoundboardData();
        ListTag favoriteSoundsTag = compoundTag.getList("FavoriteSounds", 10);
        for (int i = 0; i < favoriteSoundsTag.size(); ++i) {
            CompoundTag playerTag = favoriteSoundsTag.getCompound(i);
            UUID playerUUID = playerTag.getUUID("PlayerUUID");
            ListTag soundsListTag = playerTag.getList("FavoriteSounds", 8);
            ArrayList<String> sounds = new ArrayList<String>();
            for (int j = 0; j < soundsListTag.size(); ++j) {
                sounds.add(soundsListTag.getString(j));
            }
            data.favoriteSounds.put(playerUUID, sounds);
        }
        return data;
    }

    public List<String> getFavoriteSounds(ServerPlayer player) {
        return this.favoriteSounds.getOrDefault(player.getUUID(), new ArrayList());
    }

    private void addFavoriteSound(ServerPlayer player, String sound) {
        this.favoriteSounds.computeIfAbsent(player.getUUID(), p -> new ArrayList()).add(sound);
        this.setDirty();
    }

    private void removeFavoriteSound(ServerPlayer player, String sound) {
        this.getFavoriteSounds(player).remove(sound);
        this.setDirty();
    }

    public void toggleFavoriteSound(ServerPlayer player, String sound) {
        if (this.getFavoriteSounds(player).contains(sound)) {
            this.removeFavoriteSound(player, sound);
        } else {
            this.addFavoriteSound(player, sound);
        }
    }

    public static SoundboardData get(MinecraftServer server) {
        return (SoundboardData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, NAME);
    }
}

