/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.data;

import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.network.ClientboundFakeSkinDataPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeSkinData
extends SavedData {
    public static final String NAME = "FakeSkinData";
    public static final SavedData.Factory<FakeSkinData> FACTORY = new SavedData.Factory(FakeSkinData::new, FakeSkinData::create, null);
    private final Map<UUID, String> skins = new HashMap<UUID, String>();

    public void remove(ServerPlayer player) {
        this.skins.remove(player.getUUID());
        this.setDirty();
    }

    public void setSkin(ServerPlayer player, String link) {
        this.skins.put(player.getUUID(), link);
        this.setDirty();
    }

    @Nullable
    public String getSkin(UUID id) {
        return this.skins.get(id);
    }

    public ClientboundFakeSkinDataPacket getPacket() {
        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer());
        return new ClientboundFakeSkinDataPacket(this.save(new CompoundTag(), (HolderLookup.Provider)server.registryAccess()));
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag pCompoundTag, @NotNull HolderLookup.Provider registries) {
        this.skins.forEach((uuid, name) -> pCompoundTag.putString(uuid.toString(), name));
        return pCompoundTag;
    }

    @NotNull
    public static FakeSkinData create(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registries) {
        FakeSkinData data = new FakeSkinData();
        compoundTag.getAllKeys().forEach(key -> {
            try {
                UUID uuid = UUID.fromString(key);
                String name = compoundTag.getString(key);
                data.skins.put(uuid, name);
            }
            catch (Exception e) {
                Utils.LOGGER.error("[Fake Skin] Invalid skin data for {}:", key, (Object)e);
            }
        });
        return data;
    }

    public static FakeSkinData get(MinecraftServer server) {
        return (FakeSkinData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, NAME);
    }

    public static FakeSkinData local() {
        return Utils.PROXY.getFakeSkinData();
    }
}

