/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.data;

import com.mojang.authlib.GameProfile;
import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.network.ClientboundFakeNameDataPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class FakeNameData
extends SavedData {
    public static final String NAME = "FakeNameData";
    public static final SavedData.Factory<FakeNameData> FACTORY = new SavedData.Factory(FakeNameData::new, FakeNameData::create, null);
    private final Map<UUID, String> names = new HashMap<UUID, String>();

    public void remove(ServerPlayer player) {
        this.names.remove(player.getUUID());
        this.setDirty();
    }

    public void setName(ServerPlayer player, String name) {
        this.names.put(player.getUUID(), name);
        this.setDirty();
    }

    public String getName(GameProfile profile) {
        return this.getName(profile.getId(), profile.getName());
    }

    public String getName(String id, String name) {
        try {
            UUID uuid = UUID.fromString(id);
            return this.getName(uuid, name);
        }
        catch (Exception e) {
            return name;
        }
    }

    public String getName(UUID id, String name) {
        return this.names.getOrDefault(id, name);
    }

    public ClientboundFakeNameDataPacket getPacket() {
        MinecraftServer server = Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer());
        return new ClientboundFakeNameDataPacket(this.save(new CompoundTag(), (HolderLookup.Provider)server.registryAccess()));
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag pCompoundTag, @NotNull HolderLookup.Provider registries) {
        this.names.forEach((uuid, name) -> pCompoundTag.putString(uuid.toString(), name));
        return pCompoundTag;
    }

    @NotNull
    public static FakeNameData create(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registries) {
        FakeNameData data = new FakeNameData();
        compoundTag.getAllKeys().forEach(key -> {
            try {
                UUID uuid = UUID.fromString(key);
                String name = compoundTag.getString(key);
                data.names.put(uuid, name);
            }
            catch (Exception e) {
                Utils.LOGGER.error("[Fake Name] Invalid name data for {}:", key, (Object)e);
            }
        });
        return data;
    }

    public static FakeNameData get(MinecraftServer server) {
        return (FakeNameData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, NAME);
    }

    public static FakeNameData local() {
        return Utils.PROXY.getFakeNameData();
    }
}

