/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.data;

import dev.lucaargolo.utils.network.ClientboundColorfulSkyPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ColorfulSkyData
extends SavedData {
    public static final String NAME = "ColorfulSkyData";
    public static final SavedData.Factory<ColorfulSkyData> FACTORY = new SavedData.Factory(ColorfulSkyData::new, ColorfulSkyData::create, null);
    private boolean active = false;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float near = -8.0f;
    private float far = 200.0f;

    public void setColorfulSky(boolean active) {
        this.active = active;
        this.red = 1.0f;
        this.green = 1.0f;
        this.blue = 1.0f;
        this.near = -8.0f;
        this.far = 200.0f;
        this.setDirty();
    }

    public void setColorfulSky(float red, float green, float blue, float near, float far) {
        this.active = true;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.near = near;
        this.far = far;
        this.setDirty();
    }

    public void setColorfulSky(float red, float green, float blue) {
        this.setColorfulSky(red, green, blue, -8.0f, 1000.0f);
    }

    public ClientboundColorfulSkyPacket getPacket() {
        return new ClientboundColorfulSkyPacket(this.active, this.red, this.green, this.blue, this.near, this.far);
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag pCompoundTag, @NotNull HolderLookup.Provider registries) {
        pCompoundTag.putBoolean("active", this.active);
        pCompoundTag.putFloat("red", this.red);
        pCompoundTag.putFloat("green", this.green);
        pCompoundTag.putFloat("blue", this.blue);
        pCompoundTag.putFloat("near", this.near);
        pCompoundTag.putFloat("far", this.far);
        return pCompoundTag;
    }

    @NotNull
    public static ColorfulSkyData create(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registries) {
        ColorfulSkyData data = new ColorfulSkyData();
        data.active = compoundTag.getBoolean("active");
        data.red = compoundTag.getFloat("red");
        data.green = compoundTag.getFloat("green");
        data.blue = compoundTag.getFloat("blue");
        data.near = compoundTag.getFloat("near");
        data.far = compoundTag.getFloat("far");
        return data;
    }

    public boolean isActive() {
        return this.active;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getNear() {
        return this.near;
    }

    public float getFar() {
        return this.far;
    }

    public static ColorfulSkyData get(MinecraftServer server) {
        return (ColorfulSkyData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, NAME);
    }
}

