/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.data;

import dev.lucaargolo.utils.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BalloonModeData
extends SavedData {
    public static final String NAME = "BalloonModeData";
    public static final SavedData.Factory<BalloonModeData> FACTORY = new SavedData.Factory(BalloonModeData::new, BalloonModeData::create, null);
    private final Set<UUID> players = new HashSet<UUID>();

    public void set(ServerPlayer player, boolean value) {
        if (value) {
            this.players.remove(player.getUUID());
        } else {
            this.players.add(player.getUUID());
        }
        this.setDirty();
    }

    public boolean isActive(ServerPlayer player) {
        return !this.players.contains(player.getUUID());
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag pCompoundTag, @NotNull HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        this.players.forEach(uuid -> list.add((Object)StringTag.valueOf((String)uuid.toString())));
        pCompoundTag.put("players", (Tag)list);
        return pCompoundTag;
    }

    @NotNull
    public static BalloonModeData create(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registries) {
        BalloonModeData data = new BalloonModeData();
        ListTag list = compoundTag.getList("players", 8);
        list.forEach(tag -> {
            try {
                UUID uuid = UUID.fromString(tag.getAsString());
                data.players.add(uuid);
            }
            catch (Exception e) {
                Utils.LOGGER.error("[Balloon Mode] Invalid uuid data for {}:", tag, (Object)e);
            }
        });
        return data;
    }

    public static BalloonModeData get(MinecraftServer server) {
        return (BalloonModeData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, NAME);
    }
}

