/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.lucaargolo.utils.menu.InvSeeMenu;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class InvSeeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"invsee").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(InvSeeCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer executor = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        final ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
        executor.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.literal((String)"InvSee");
            }

            public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new InvSeeMenu(containerId, playerInventory, target.getUUID(), target.getInventory());
            }

            public void writeClientSideData(@NotNull AbstractContainerMenu menu, @NotNull RegistryFriendlyByteBuf buffer) {
                buffer.writeUUID(target.getUUID());
            }
        });
        return 1;
    }
}

