/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.lucaargolo.utils.Arkanis;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import io.github.ladysnake.pal.VanillaAbilities;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class FlyCommand {
    public static final AbilitySource FLIGHT = Pal.getAbilitySource((String)"utils", (String)"flight_command");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fly").requires(s -> s.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(FlyCommand::execute))).executes(FlyCommand::execute));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        if (FLIGHT.grants((Player)player, VanillaAbilities.INVULNERABLE)) {
            Arkanis.sendMessage(context, "Removing flight for " + player.getDisplayName().getString(), true, ChatFormatting.RED);
            FLIGHT.revokeFrom((Player)player, VanillaAbilities.INVULNERABLE);
        } else {
            Arkanis.sendMessage(context, "Allowing flight for " + player.getDisplayName().getString(), true, ChatFormatting.GREEN);
            FLIGHT.grantTo((Player)player, VanillaAbilities.INVULNERABLE);
        }
        return 1;
    }
}

