/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.lucaargolo.utils.Arkanis;
import dev.lucaargolo.utils.data.FakeSkinData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class FakeSkinCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fakeskin").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"link", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(FakeSkinCommand::executeSet))).executes(FakeSkinCommand::executeSet)))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(FakeSkinCommand::executeClear))).executes(FakeSkinCommand::executeClear)));
    }

    private static int executeSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        String link = StringArgumentType.getString(context, (String)"link");
        FakeSkinData data = FakeSkinData.get(player.server);
        data.setSkin(player, link);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)data.getPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        String nick = player.getGameProfile().getName();
        Arkanis.sendMessage(context, "Successfully set " + nick + "'s skin to " + link, true, ChatFormatting.GREEN);
        return 1;
    }

    private static int executeClear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        FakeSkinData data = FakeSkinData.get(player.server);
        data.remove(player);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)data.getPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        String nick = player.getGameProfile().getName();
        Arkanis.sendMessage(context, "Successfully cleared " + nick + "'s skin", true, ChatFormatting.GREEN);
        return 1;
    }
}

