/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.lucaargolo.utils.Arkanis;
import dev.lucaargolo.utils.data.FakeNameData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class FakeNameCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fakename").requires(s -> s.hasPermission(2))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(FakeNameCommand::executeSet))).executes(FakeNameCommand::executeSet)))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(FakeNameCommand::executeClear))).executes(FakeNameCommand::executeClear))).then(Commands.literal((String)"who").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(FakeNameCommand::executeWho))));
    }

    private static int executeSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        String name = StringArgumentType.getString(context, (String)"name");
        FakeNameData data = FakeNameData.get(player.server);
        data.setName(player, name);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)data.getPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.refreshTabListName();
        player.refreshDisplayName();
        String nick = player.getGameProfile().getName();
        Arkanis.sendMessage(context, "Successfully set " + nick + "'s name to " + name, true, ChatFormatting.GREEN);
        return 1;
    }

    private static int executeClear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        FakeNameData data = FakeNameData.get(player.server);
        data.remove(player);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)data.getPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.refreshTabListName();
        player.refreshDisplayName();
        String nick = player.getGameProfile().getName();
        Arkanis.sendMessage(context, "Successfully cleared " + nick + "'s name", true, ChatFormatting.GREEN);
        return 1;
    }

    private static int executeWho(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        String fakeName = player.getDisplayName().getString();
        String original = player.getGameProfile().getName();
        Arkanis.sendMessage(context, fakeName + " is " + original, true, ChatFormatting.YELLOW);
        return 1;
    }
}

