/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.lucaargolo.utils.Arkanis;
import dev.lucaargolo.utils.attachment.BalloonConfigAttachment;
import dev.lucaargolo.utils.attachment.ModAttachments;
import dev.lucaargolo.utils.data.BalloonModeData;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class BalloonCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"balloon").requires(s -> s.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"color").then(Commands.literal((String)"text").then(((RequiredArgumentBuilder)Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(BalloonCommand::executeColorText))).executes(BalloonCommand::executeColorText)))).then(Commands.literal((String)"outline").then(((RequiredArgumentBuilder)Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(BalloonCommand::executeColorOutline))).executes(BalloonCommand::executeColorOutline)))).then(Commands.literal((String)"background").then(((RequiredArgumentBuilder)Commands.argument((String)"color", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(BalloonCommand::executeColorBackground))).executes(BalloonCommand::executeColorBackground))))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"bool", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(BalloonCommand::executeSet))).executes(BalloonCommand::executeSet)))).then(((LiteralArgumentBuilder)Commands.literal((String)"toggle").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(BalloonCommand::executeToggle))).executes(BalloonCommand::executeToggle))).executes(BalloonCommand::executeToggle));
    }

    private static void set(CommandContext<CommandSourceStack> context, ServerPlayer player, boolean bool) {
        BalloonModeData data = BalloonModeData.get(player.server);
        data.set(player, bool);
        if (bool) {
            Arkanis.sendMessage(context, "Enabled balloon mode for " + player.getDisplayName().getString(), true, ChatFormatting.GREEN);
        } else {
            Arkanis.sendMessage(context, "Disabled balloon mode for " + player.getDisplayName().getString(), true, ChatFormatting.RED);
        }
    }

    private static int executeColor(CommandContext<CommandSourceStack> context, BiFunction<BalloonConfigAttachment, Integer, BalloonConfigAttachment> function) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        String color = StringArgumentType.getString(context, (String)"color");
        player.setData(ModAttachments.BALLOON_CONFIG, (Object)function.apply((BalloonConfigAttachment)player.getData(ModAttachments.BALLOON_CONFIG), BalloonCommand.parseColor(color)));
        Arkanis.sendMessage(context, "Changed balloon color for " + player.getDisplayName().getString(), true, ChatFormatting.GREEN);
        return 1;
    }

    private static int executeColorText(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return BalloonCommand.executeColor(context, (config, color) -> new BalloonConfigAttachment((int)color, (int)color, config.backgroundColor()));
    }

    private static int executeColorOutline(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return BalloonCommand.executeColor(context, (config, color) -> new BalloonConfigAttachment(config.textColor(), (int)color, config.backgroundColor()));
    }

    private static int executeColorBackground(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return BalloonCommand.executeColor(context, (config, color) -> new BalloonConfigAttachment(config.textColor(), config.outlineColor(), (int)color));
    }

    private static int executeSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        boolean bool = BoolArgumentType.getBool(context, (String)"bool");
        BalloonCommand.set(context, player, bool);
        return 1;
    }

    private static int executeToggle(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player;
        try {
            player = EntityArgument.getPlayer(context, (String)"player");
        }
        catch (Exception e) {
            player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        }
        BalloonModeData data = BalloonModeData.get(player.server);
        BalloonCommand.set(context, player, !data.isActive(player));
        return 1;
    }

    private static int parseColor(String color) {
        if (((String)(color = ((String)color).trim())).matches("\\d+")) {
            return Integer.parseInt((String)color);
        }
        if (((String)color).startsWith("#")) {
            color = ((String)color).substring(1);
        }
        if (((String)color).matches("[0-9a-fA-F]{6}")) {
            color = "FF" + (String)color;
        } else if (!((String)color).matches("[0-9a-fA-F]{8}")) {
            throw new IllegalArgumentException("Invalid color format: " + (String)color);
        }
        return (int)Long.parseLong((String)color, 16);
    }
}

