/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.misc;

import com.mojang.blaze3d.platform.NativeImage;
import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.client.misc.FilteredDynamicTexture;
import dev.lucaargolo.utils.client.misc.HTTPUtilities;
import dev.lucaargolo.utils.client.misc.WebTexture;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class WebTextureHandler {
    public static final WebTexture EMPTY = new WebTexture(Utils.id("textures/misc/empty.png"), 4, 3);
    private static final Map<String, Object> FILTERED = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> UNFILTERED = new ConcurrentHashMap<String, Object>();
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public static WebTexture get(String link, boolean filtered) {
        Map<String, Object> maps = filtered ? FILTERED : UNFILTERED;
        Object current = maps.computeIfAbsent(link, k -> executor.submit(() -> {
            int index;
            ByteBuffer r = ByteBuffer.allocateDirect(0);
            if (link.startsWith("http")) {
                r = HTTPUtilities.downloadUrl(link);
            } else if (link.startsWith("data:") && (index = link.indexOf("base64,")) != -1) {
                byte[] data = Base64.getDecoder().decode(link.substring(index + 7));
                r = ByteBuffer.allocateDirect(data.length);
                r.put(data);
                r.flip();
            }
            ByteBuffer resource = r;
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.execute(() -> {
                int[] width = new int[1];
                int[] height = new int[1];
                int[] channels = new int[1];
                ByteBuffer buffer = STBImage.stbi_load_from_memory((ByteBuffer)resource, (int[])width, (int[])height, (int[])channels, (int)0);
                try {
                    assert (buffer != null);
                    NativeImage image = new NativeImage(NativeImage.Format.getStbFormat((int)channels[0]), width[0], height[0], true, MemoryUtil.memAddress((ByteBuffer)buffer));
                    FilteredDynamicTexture texture = filtered ? new FilteredDynamicTexture(image) : new DynamicTexture(image);
                    ResourceLocation location = minecraft.getTextureManager().register((filtered ? "filtered_" : "") + HTTPUtilities.hashUrl(link), (DynamicTexture)texture);
                    maps.put(link, new WebTexture(location, width[0], height[0]));
                }
                catch (Exception e) {
                    maps.put(link, EMPTY);
                }
            });
        }));
        if (current instanceof WebTexture) {
            WebTexture texture = (WebTexture)current;
            return texture;
        }
        if (current instanceof Future) {
            return EMPTY;
        }
        return EMPTY;
    }

    public static void clear() {
        FILTERED.clear();
        UNFILTERED.clear();
    }
}

