/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.misc;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public record WebTexture(ResourceLocation location, int width, int height) {
    private static final Map<ResourceLocation, WebTexture> cache = new HashMap<ResourceLocation, WebTexture>();

    public static WebTexture fromVanilla(ResourceLocation location) {
        return cache.computeIfAbsent(location, loc -> {
            DynamicTexture dynamicTexture;
            AbstractTexture abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(loc);
            int[] width = new int[1];
            int[] height = new int[1];
            if (abstractTexture instanceof DynamicTexture && (dynamicTexture = (DynamicTexture)abstractTexture).getPixels() != null) {
                width[0] = dynamicTexture.getPixels().getWidth();
                height[0] = dynamicTexture.getPixels().getHeight();
            } else {
                GL11.glBindTexture((int)3553, (int)abstractTexture.getId());
                GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4096, (int[])width);
                GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4097, (int[])height);
            }
            return new WebTexture((ResourceLocation)loc, width[0], height[0]);
        });
    }

    public static void clearCache() {
        cache.clear();
    }
}

