/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.attachment.BalloonConfigAttachment;
import dev.lucaargolo.utils.attachment.BalloonHistoryAttachment;
import dev.lucaargolo.utils.attachment.ModAttachments;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.attachment.AttachmentType;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.api.nameplate.EntityNameplateCustomization;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.permissions.Permissions;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TalkBalloonRenderer {
    private static final ResourceLocation BALLOON_TEXTURE = Utils.id("textures/gui/balloon.png");
    private static final ResourceLocation OUTLINE_TEXTURE = Utils.id("textures/gui/balloon_outline.png");
    private static final float HEIGHT_OFFSET = 0.9f;
    private static final int DISTANCE = 3;
    private static final int MIN_WIDTH = 13;
    private static final int MAX_WIDTH = 180;

    public static void renderBalloons(EntityRenderDispatcher dispatcher, AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, Font font) {
        BalloonHistoryAttachment history = (BalloonHistoryAttachment)player.getData((AttachmentType)ModAttachments.BALLOON_HISTORY.get());
        if (history.messages().isEmpty()) {
            return;
        }
        Avatar avatar = AvatarManager.getAvatar((Entity)player);
        EntityNameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.ENTITY;
        boolean hasCustomNameplate = custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        boolean enabled = (Integer)Configs.ENTITY_NAMEPLATE.value > 0 && !AvatarManager.panic && hasCustomNameplate;
        Quaternionf rotation = Axis.YP.rotationDegrees(TalkBalloonRenderer.toEulerXyzDegrees((Quaternionf)dispatcher.cameraOrientation()).y + 180.0f);
        int balloonDistance = 0;
        int previousBalloonHeight = 0;
        for (int i = history.messages().size() - 1; i >= 0; --i) {
            BalloonHistoryAttachment.Message s = history.messages().get(i);
            poseStack.pushPose();
            FiguraVec3 pivot = FiguraVec3.of((double)0.0, (double)(player.getBbHeight() + 0.9f), (double)0.0);
            if (enabled && avatar != null && hasCustomNameplate && custom.getPivot() != null) {
                pivot = custom.getPivot();
            }
            poseStack.translate(pivot.x, pivot.y, pivot.z);
            poseStack.mulPose(rotation);
            if (enabled && avatar != null && hasCustomNameplate && custom.getPos() != null) {
                FiguraVec3 pos = custom.getPos();
                poseStack.translate(pos.x, pos.y, pos.z);
            }
            FiguraVec3 scaleVec = FiguraVec3.of((double)-0.025f, (double)-0.025f, (double)0.025f);
            if (enabled && avatar != null && hasCustomNameplate && custom.getScale() != null) {
                scaleVec.multiply(custom.getScale());
            }
            poseStack.scale((float)scaleVec.x, (float)scaleVec.y, (float)scaleVec.z);
            List dividedMessage = font.split((FormattedText)s.component(), 180);
            int greatestTextWidth = 0;
            for (FormattedCharSequence text : dividedMessage) {
                int textWidth = font.width(text);
                if (textWidth <= greatestTextWidth) continue;
                greatestTextWidth = textWidth;
            }
            BalloonConfigAttachment config = (BalloonConfigAttachment)player.getData(ModAttachments.BALLOON_CONFIG);
            int textColor = config.textColor();
            int outlineColor = config.outlineColor();
            int backgroundColor = config.backgroundColor();
            int balloonPadding = 8;
            int balloonWidth = Mth.clamp((int)greatestTextWidth, (int)13, (int)180) + balloonPadding * 2;
            int balloonHeight = dividedMessage.size() + balloonPadding / 8;
            if (balloonWidth % 2 == 0) {
                --balloonWidth;
            }
            if (previousBalloonHeight != 0) {
                balloonDistance += 9 * previousBalloonHeight + 3;
            }
            previousBalloonHeight = balloonHeight;
            int j = balloonHeight - 1;
            int baseX = balloonWidth / 2;
            int baseY = -balloonHeight - j * 7 - j;
            TalkBalloonRenderer.drawBalloon(poseStack, buffer, balloonDistance, backgroundColor, balloonWidth, balloonHeight, j, baseX, baseY, BALLOON_TEXTURE);
            poseStack.translate(0.0f, 0.0f, 0.01f);
            TalkBalloonRenderer.drawBalloon(poseStack, buffer, balloonDistance, outlineColor, balloonWidth, balloonHeight, j, baseX, baseY, OUTLINE_TEXTURE);
            poseStack.translate(0.0f, 0.0f, -0.02f);
            Matrix4f pose = poseStack.last().pose();
            if (dividedMessage.size() > 1) {
                int textDistance = 0;
                for (FormattedCharSequence text : dividedMessage) {
                    font.drawInBatch(text, (float)(-font.width(text)) / 2.0f + 1.0f, -(9.0f * (float)balloonHeight - 10.0f) - (float)balloonDistance + (float)textDistance + (float)balloonPadding - (float)balloonPadding / 2.0f, textColor, false, pose, buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    textDistance += 9;
                }
            } else {
                font.drawInBatch(s.component(), (float)(-greatestTextWidth) / 2.0f + 1.0f, (float)(balloonHeight - balloonDistance - balloonPadding) + (float)balloonPadding / 4.0f, textColor, false, pose, buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            poseStack.popPose();
        }
    }

    private static void drawBalloon(PoseStack poseStack, MultiBufferSource buffer, int balloonDistance, int backgroundColor, int balloonWidth, int balloonHeight, int j, int baseX, int baseY, ResourceLocation balloonTexture) {
        VertexConsumer balloonConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)balloonTexture));
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, -baseX - 2, baseY - balloonDistance, 5, 5, 0.0f, 0.0f, 5, 5, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, -baseX - 2, baseY + 5 - balloonDistance, 5, balloonHeight + j * 8, 0.0f, 6.0f, 5, 1, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, -baseX - 2, 5 - balloonDistance, 5, 5, 0.0f, 8.0f, 5, 5, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, -baseX + 3, baseY - balloonDistance, balloonWidth - 4, 5, 6.0f, 0.0f, 5, 5, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, -baseX + 3, baseY + 5 - balloonDistance, balloonWidth - 4, balloonHeight + j * 8, 6.0f, 6.0f, 5, 1, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, -baseX + 3, 5 - balloonDistance, balloonWidth - 4, 5, 6.0f, 8.0f, 5, 5, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, baseX - 2, baseY - balloonDistance, 5, 5, 12.0f, 0.0f, 5, 5, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, baseX - 2, baseY + 5 - balloonDistance, 5, balloonHeight + j * 8, 12.0f, 6.0f, 5, 1, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, baseX - 2, 5 - balloonDistance, 5, 5, 12.0f, 8.0f, 5, 5, 32, 32, backgroundColor);
        TalkBalloonRenderer.fill(poseStack, balloonConsumer, -3, 9, 7, 4, 18.0f, 6.0f, 7, 4, 32, 32, backgroundColor);
    }

    private static void fill(PoseStack poseStack, VertexConsumer vertexConsumer, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int color) {
        TalkBalloonRenderer.fill(poseStack, vertexConsumer, x, y, width, height, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight, color);
    }

    private static void fill(PoseStack poseStack, VertexConsumer vertexConsumer, int x, int y, int width, int height, float u0, float u1, float v0, float v1, int color) {
        PoseStack.Pose entry = poseStack.last();
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        vertexConsumer.addVertex(entry.pose(), (float)(x + width), (float)y, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, v0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry.pose(), (float)(x + width), (float)(y + height), 0.0f).setColor(r, g, b, 1.0f).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry.pose(), (float)x, (float)(y + height), 0.0f).setColor(r, g, b, 1.0f).setUv(u0, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(entry, 0.0f, -1.0f, 0.0f);
        vertexConsumer.addVertex(entry.pose(), (float)x, (float)y, 0.0f).setColor(r, g, b, 1.0f).setUv(u0, v0).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(entry, 0.0f, -1.0f, 0.0f);
    }

    private static Vector3f toEulerXyz(Quaternionf quaternionf) {
        float f = quaternionf.w() * quaternionf.w();
        float g = quaternionf.x() * quaternionf.x();
        float h = quaternionf.y() * quaternionf.y();
        float i = quaternionf.z() * quaternionf.z();
        float j = f + g + h + i;
        float k = 2.0f * quaternionf.w() * quaternionf.x() - 2.0f * quaternionf.y() * quaternionf.z();
        float l = (float)Math.asin(k / j);
        return Math.abs(k) > 0.999f * j ? new Vector3f(l, 2.0f * (float)Math.atan2(quaternionf.y(), quaternionf.w()), 0.0f) : new Vector3f(l, (float)Math.atan2(2.0f * quaternionf.x() * quaternionf.z() + 2.0f * quaternionf.y() * quaternionf.w(), f - g - h + i), (float)Math.atan2(2.0f * quaternionf.x() * quaternionf.y() + 2.0f * quaternionf.w() * quaternionf.z(), f - g + h - i));
    }

    private static Vector3f toEulerXyzDegrees(Quaternionf quaternionf) {
        Vector3f vec3f = TalkBalloonRenderer.toEulerXyz(quaternionf);
        return new Vector3f((float)Math.toDegrees(vec3f.x()), (float)Math.toDegrees(vec3f.y()), (float)Math.toDegrees(vec3f.z()));
    }
}

