/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.misc;

import dev.lucaargolo.utils.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HTTPUtilities {
    private static final Path CACHE_DIR = Paths.get(System.getProperty("user.dir"), ".darkutils");

    public static ByteBuffer downloadUrl(String url) {
        return HTTPUtilities.downloadUrls(url)[0];
    }

    public static ByteBuffer[] downloadUrls(String ... urls) {
        ByteBuffer[] buffers = new ByteBuffer[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            if (url.isEmpty()) continue;
            Utils.LOGGER.info("[HTTP Utilities] Requesting {}", (Object)url);
            try {
                Path cachePath = CACHE_DIR.resolve(HTTPUtilities.hashUrl(url));
                if (Files.exists(cachePath, new LinkOption[0])) {
                    Utils.LOGGER.info("[HTTP Utilities] Cache found for {}", (Object)url);
                    byte[] cachedData = Files.readAllBytes(cachePath);
                    buffers[i] = ByteBuffer.allocateDirect(cachedData.length);
                    buffers[i].put(cachedData).flip();
                    continue;
                }
                try (HttpClient client = HttpClient.newHttpClient();){
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36").build();
                    HttpResponse<byte[]> response = client.send(request, HttpResponse.BodyHandlers.ofByteArray());
                    byte[] body = response.body();
                    if (response.statusCode() >= 200 && response.statusCode() < 300) {
                        Utils.LOGGER.info("[HTTP Utilities] Writing cache for {}", (Object)url);
                        Files.write(cachePath, body, new OpenOption[0]);
                    }
                    buffers[i] = ByteBuffer.allocateDirect(body.length);
                    buffers[i].put(body).flip();
                    continue;
                }
            }
            catch (Exception e) {
                Utils.LOGGER.error("[HTTP Utilities] Failed to request url {}:", (Object)url, (Object)e);
                buffers[i] = ByteBuffer.allocateDirect(0);
            }
        }
        return buffers;
    }

    public static String hashUrl(String url) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(url.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    static {
        try {
            Files.createDirectories(CACHE_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create .darkutils cache directory", e);
        }
    }
}

