/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.lucaargolo.utils.client.misc.HTTPUtilities;
import dev.lucaargolo.utils.client.misc.WebTexture;
import dev.lucaargolo.utils.client.misc.WebTextureHandler;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.StringRepresentable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class HTTPCubeMapHandler {
    private static int EMPTY = 0;
    private static final Map<String, Object> MAPS = new HashMap<String, Object>();
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    public static void load() {
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        WebTexture empty = WebTextureHandler.EMPTY;
        resourceManager.getResource(empty.location()).ifPresent(resource -> {
            try (InputStream stream = resource.open();){
                byte[] array = stream.readAllBytes();
                ByteBuffer buffer = ByteBuffer.allocateDirect(array.length);
                buffer.put(array);
                buffer.flip();
                EMPTY = HTTPCubeMapHandler.register(HTTPCubeMapHandler.fromCrossMap(buffer));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static int get(CubeMap.Format format, String[] links) {
        String location = String.join((CharSequence)":", links);
        Object current = MAPS.computeIfAbsent(location, k -> executor.submit(() -> {
            ByteBuffer[] buffers = HTTPUtilities.downloadUrls(links);
            RenderSystem.recordRenderCall(() -> {
                try {
                    CubeMap map = switch (format.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> HTTPCubeMapHandler.fromCrossMap(buffers[0]);
                        case 1 -> HTTPCubeMapHandler.fromLineMap(buffers[0]);
                        case 2 -> HTTPCubeMapHandler.fromSeparateMap(buffers);
                    };
                    MAPS.put(location, HTTPCubeMapHandler.register(map));
                }
                catch (Exception e) {
                    MAPS.put(location, EMPTY);
                }
            });
        }));
        if (current instanceof Integer) {
            return (Integer)current;
        }
        if (current instanceof Future) {
            return EMPTY;
        }
        return EMPTY;
    }

    public static void clear() {
        MAPS.values().forEach(object -> {
            if (object instanceof Integer) {
                GL11.glDeleteTextures((int)((Integer)object));
            }
        });
        MAPS.clear();
    }

    private static CubeMap fromSeparateMap(ByteBuffer[] imageBuffers) {
        if (imageBuffers.length != 6) {
            throw new IllegalArgumentException("Number of textures is different than 6");
        }
        ByteBuffer[] buffers = new ByteBuffer[6];
        int[] width = new int[1];
        int[] height = new int[1];
        int[] channels = new int[1];
        int s = -1;
        for (int i = 0; i < 6; ++i) {
            buffers[i] = STBImage.stbi_load_from_memory((ByteBuffer)imageBuffers[0], (int[])width, (int[])height, (int[])channels, (int)4);
            if (buffers[i] == null) {
                throw new RuntimeException("Failed to load image: " + STBImage.stbi_failure_reason());
            }
            if (width[0] != height[0]) {
                throw new RuntimeException("Invalid cubemap face size. Faces must be square.");
            }
            if (i > 0 && width[0] != s) {
                throw new RuntimeException("Invalid cubemap face size. Faces must all have the same size.");
            }
            s = width[0];
        }
        return new CubeMap(buffers, width[0], height[0], () -> {
            for (int i = 0; i < 6; ++i) {
                STBImage.stbi_image_free((ByteBuffer)buffers[i]);
            }
        });
    }

    private static CubeMap fromLineMap(ByteBuffer imageBuffer) {
        int[] width = new int[1];
        int[] height = new int[1];
        int[] channels = new int[1];
        ByteBuffer buffer = STBImage.stbi_load_from_memory((ByteBuffer)imageBuffer, (int[])width, (int[])height, (int[])channels, (int)4);
        if (buffer == null) {
            throw new RuntimeException("Failed to load image: " + STBImage.stbi_failure_reason());
        }
        if (width[0] % 6 != 0) {
            throw new RuntimeException("Invalid image dimensions for line cubemap. Image width must be a multiple of 6");
        }
        int faceWidth = width[0] / 6;
        int faceHeight = height[0];
        if (faceWidth != faceHeight) {
            throw new RuntimeException("Invalid cubemap face size. Faces must be square.");
        }
        ByteBuffer[] buffers = new ByteBuffer[6];
        for (int i = 0; i < 6; ++i) {
            buffers[i] = MemoryUtil.memAlloc((int)(faceWidth * faceHeight * 4));
            for (int y = 0; y < faceHeight; ++y) {
                int srcOffset = (y * width[0] + i * faceWidth) * 4;
                for (int x = 0; x < faceWidth; ++x) {
                    int pixelIndex = srcOffset + x * 4;
                    buffers[i].put(buffer.get(pixelIndex)).put(buffer.get(pixelIndex + 1)).put(buffer.get(pixelIndex + 2)).put(buffer.get(pixelIndex + 3));
                }
            }
            buffers[i].flip();
        }
        STBImage.stbi_image_free((ByteBuffer)buffer);
        return new CubeMap(buffers, width[0], height[0], () -> {
            for (int i = 0; i < 6; ++i) {
                MemoryUtil.memFree((Buffer)buffers[i]);
            }
        });
    }

    private static CubeMap fromCrossMap(ByteBuffer imageBuffer) {
        int[] width = new int[1];
        int[] height = new int[1];
        int[] channels = new int[1];
        ByteBuffer buffer = STBImage.stbi_load_from_memory((ByteBuffer)imageBuffer, (int[])width, (int[])height, (int[])channels, (int)4);
        if (buffer == null) {
            throw new RuntimeException("Failed to load image: " + STBImage.stbi_failure_reason());
        }
        if (width[0] % 4 != 0 || height[0] % 3 != 0) {
            throw new RuntimeException("Invalid image dimensions for cross cubemap. Image width must be a multiple of 4 and height a multiple of 3.");
        }
        int faceWidth = width[0] / 4;
        int faceHeight = height[0] / 3;
        if (faceWidth != faceHeight) {
            throw new RuntimeException("Invalid cubemap face size. Faces must be square.");
        }
        int[][] faceCoords = new int[][]{{2 * faceWidth, faceHeight}, {0, faceHeight}, {faceWidth, 0}, {faceWidth, 2 * faceHeight}, {faceWidth, faceHeight}, {3 * faceWidth, faceHeight}};
        ByteBuffer[] buffers = new ByteBuffer[6];
        for (int face = 0; face < 6; ++face) {
            buffers[face] = MemoryUtil.memAlloc((int)(faceWidth * faceHeight * 4));
            int startX = faceCoords[face][0];
            int startY = faceCoords[face][1];
            for (int y = 0; y < faceHeight; ++y) {
                int srcY = startY + y;
                int srcOffset = (srcY * width[0] + startX) * 4;
                for (int x = 0; x < faceWidth; ++x) {
                    int pixelIndex = srcOffset + x * 4;
                    buffers[face].put(buffer.get(pixelIndex)).put(buffer.get(pixelIndex + 1)).put(buffer.get(pixelIndex + 2)).put(buffer.get(pixelIndex + 3));
                }
            }
            buffers[face].flip();
        }
        STBImage.stbi_image_free((ByteBuffer)buffer);
        return new CubeMap(buffers, faceWidth, faceHeight, () -> {
            for (int i = 0; i < 6; ++i) {
                MemoryUtil.memFree((Buffer)buffers[i]);
            }
        });
    }

    private static int register(CubeMap data) {
        int textureId = GL11.glGenTextures();
        GL11.glBindTexture((int)34067, (int)textureId);
        for (int i = 0; i < 6; ++i) {
            GL11.glPixelStorei((int)3314, (int)0);
            GL11.glPixelStorei((int)3316, (int)0);
            GL11.glPixelStorei((int)3315, (int)0);
            GL11.glPixelStorei((int)3317, (int)4);
            GL11.glTexImage2D((int)(34069 + i), (int)0, (int)32856, (int)data.width(), (int)data.height(), (int)0, (int)6408, (int)5121, (ByteBuffer)data.buffers()[i]);
        }
        GL11.glTexParameteri((int)34067, (int)10241, (int)9729);
        GL11.glTexParameteri((int)34067, (int)10240, (int)9729);
        GL11.glTexParameteri((int)34067, (int)10242, (int)33071);
        GL11.glTexParameteri((int)34067, (int)10243, (int)33071);
        GL11.glTexParameteri((int)34067, (int)32882, (int)33071);
        GL11.glBindTexture((int)34067, (int)0);
        data.close();
        return textureId;
    }

    public record CubeMap(ByteBuffer[] buffers, int width, int height, Closeable closeable) {
        public void close() {
            try {
                this.closeable.close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }

        public static enum Format implements StringRepresentable
        {
            CROSS("Cross"),
            LINE("Line"),
            SEPARATE("Separate");

            public static final StreamCodec<ByteBuf, Format> STREAM_CODEC;
            final String name;

            private Format(String name) {
                this.name = name;
            }

            @NotNull
            public String getSerializedName() {
                return this.name;
            }

            static {
                STREAM_CODEC = ByteBufCodecs.idMapper(i -> Format.values()[i], Enum::ordinal);
            }
        }
    }
}

