/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.misc;

import com.mojang.blaze3d.shaders.FogShape;
import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.data.ColorfulSkyData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="utils", value={Dist.CLIENT})
public class ColorfulSkyClientEvents {
    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        ColorfulSkyData colorfulSkyData = Utils.PROXY.getColorfulSky();
        if (colorfulSkyData.isActive()) {
            event.setRed(colorfulSkyData.getRed());
            event.setGreen(colorfulSkyData.getGreen());
            event.setBlue(colorfulSkyData.getBlue());
        }
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        ColorfulSkyData colorfulSkyData = Utils.PROXY.getColorfulSky();
        if (colorfulSkyData.isActive()) {
            event.setNearPlaneDistance(colorfulSkyData.getNear());
            event.setFarPlaneDistance(colorfulSkyData.getFar());
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        }
    }
}

