/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.misc;

import dev.lucaargolo.utils.client.gui.widget.ResizeableImageWidget;
import dev.lucaargolo.utils.mixed.bookimages.ImageBookScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="utils", value={Dist.CLIENT})
public class BookImagesClientEvents {
    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof ImageBookScreen) {
            ImageBookScreen book = (ImageBookScreen)screen;
            List children = screen.renderables;
            ArrayList<ResizeableImageWidget> hovering = new ArrayList<ResizeableImageWidget>();
            for (Renderable child : children) {
                double pMouseY;
                if (!(child instanceof ResizeableImageWidget)) continue;
                ResizeableImageWidget widget = (ResizeableImageWidget)child;
                double pMouseX = event.getMouseX();
                boolean isHovered = widget.isHoveredExtended(pMouseX, pMouseY = (double)event.getMouseY(), 3);
                if (isHovered && widget.getPage() == book.utils$getCurrentPage()) {
                    for (ResizeableImageWidget hovered : hovering) {
                        hovered.active = false;
                    }
                    hovering.add(widget);
                }
                widget.active = true;
            }
        }
    }

    @SubscribeEvent
    public static void onScreenMouseDragged(ScreenEvent.MouseDragged.Pre event) {
        List children = event.getScreen().children();
        for (GuiEventListener child : children) {
            ResizeableImageWidget widget;
            if (!(child instanceof ResizeableImageWidget) || !(widget = (ResizeableImageWidget)child).isDragging()) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onScreenMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        List children = event.getScreen().children();
        for (GuiEventListener child : children) {
            boolean result;
            ResizeableImageWidget widget;
            if (!(child instanceof ResizeableImageWidget) || !(widget = (ResizeableImageWidget)child).isDragging() || !(result = child.mouseReleased(event.getMouseX(), event.getMouseY(), event.getButton()))) continue;
            event.setCanceled(true);
        }
    }
}

