/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.gui.widget;

import dev.lucaargolo.utils.client.gui.widget.BookImageWidget;
import dev.lucaargolo.utils.mixed.bookimages.ImageBookScreen;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

@OnlyIn(value=Dist.CLIENT)
public class ResizeableImageWidget
extends BookImageWidget {
    public static final int RESIZE_BUTTON = 3;
    double dX = this.getX();
    double dY = this.getY();
    double dWidth = this.getWidth();
    double dHeight = this.getHeight();
    boolean dragging = false;
    int draggingIndex = -1;
    double oX = 0.0;
    double oY = 0.0;
    double oWidth = 0.0;
    double oHeight = 0.0;
    double oMouseX = 0.0;
    double oMouseY = 0.0;

    public ResizeableImageWidget(ImageBookScreen parent, int page, int pX, int pY, int pWidth, int pHeight, UUID image) {
        super(parent, page, pX, pY, pWidth, pHeight, image);
    }

    public ResizeableImageWidget(ImageBookScreen parent, int page, int pWidth, int pHeight, UUID image) {
        super(parent, page, pWidth, pHeight, image);
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.parent.utils$getCurrentPage() != this.page) {
            this.isHovered = false;
        } else {
            this.isHovered = this.isHoveredExtended(pMouseX, pMouseY, 0);
            if (this.dragging) {
                if (this.draggingIndex == 0 || this.draggingIndex == 4 || this.draggingIndex == 5) {
                    this.dWidth = this.oWidth + ((double)pMouseX - this.oMouseX);
                }
                if (this.draggingIndex == 1 || this.draggingIndex == 4 || this.draggingIndex == 6) {
                    this.dHeight = this.oHeight + ((double)pMouseY - this.oMouseY);
                }
                if (this.draggingIndex == 2 || this.draggingIndex == 6 || this.draggingIndex == 7) {
                    this.dX = this.oX + ((double)pMouseX - this.oMouseX);
                    this.dWidth = this.oWidth + (this.oMouseX - (double)pMouseX);
                }
                if (this.draggingIndex == 3 || this.draggingIndex == 5 || this.draggingIndex == 7) {
                    this.dY = this.oY + ((double)pMouseY - this.oMouseY);
                    this.dHeight = this.oHeight + (this.oMouseY - (double)pMouseY);
                }
                if (this.draggingIndex < 0) {
                    this.dX = this.oX + ((double)pMouseX - this.oMouseX);
                    this.dY = this.oY + ((double)pMouseY - this.oMouseY);
                }
                this.dWidth = Mth.clamp((double)this.dWidth, (double)0.0, (double)this.parent.utils$getBookWidth());
                this.dHeight = Mth.clamp((double)this.dHeight, (double)0.0, (double)this.parent.utils$getBookHeight());
                this.dX = Mth.clamp((double)this.dX, (double)0.0, (double)((double)this.parent.utils$getBookWidth() - this.dWidth));
                this.dY = Mth.clamp((double)this.dY, (double)0.0, (double)((double)this.parent.utils$getBookHeight() - this.dHeight));
                this.setX((int)this.dX);
                this.setY((int)this.dY);
                this.setWidth((int)this.dWidth);
                this.setHeight((int)this.dHeight);
                this.parent.utils$modify();
            }
            super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            boolean isHoveredExtended = this.isHoveredExtended(pMouseX, pMouseY, 3);
            if (isHoveredExtended && this.active) {
                boolean wasMouseIn = false;
                if (!this.dragging || this.draggingIndex >= 0) {
                    Vector2d[] corners = ResizeableImageWidget.getDraggableCorners(this.dX, this.dY, this.dWidth, this.dHeight);
                    for (int i = 0; i < corners.length; ++i) {
                        Vector2d corner = corners[i];
                        if (this.dragging && this.draggingIndex != i) continue;
                        boolean isMouseIn = this.draggingIndex == i || this.isMouseInDraggable(pMouseX, pMouseY, corner.x, corner.y);
                        this.drawDraggable(pGuiGraphics, corner.x, corner.y, isMouseIn ? -65536 : -1);
                        wasMouseIn = wasMouseIn || isMouseIn;
                    }
                }
                if ((this.isHovered || this.dragging) && !wasMouseIn) {
                    this.draw(pGuiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0x66FFFFFF);
                }
            }
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.parent.utils$getCurrentPage() != this.page || !this.active) {
            return false;
        }
        Vector2d[] corners = ResizeableImageWidget.getDraggableCorners(this.dX, this.dY, this.dWidth, this.dHeight);
        for (int i = 0; i < corners.length; ++i) {
            Vector2d corner = corners[i];
            if (!this.isMouseInDraggable(pMouseX, pMouseY, corner.x, corner.y) || pButton != 0) continue;
            this.dragging = true;
            this.draggingIndex = i;
            this.captureOriginals(pMouseX, pMouseY);
            return true;
        }
        if (this.isMouseIn(pMouseX, pMouseY, this.dX, this.dY, this.dWidth, this.dHeight)) {
            if (pButton == 0) {
                this.dragging = true;
                this.draggingIndex = -1;
                this.captureOriginals(pMouseX, pMouseY);
            } else if (pButton == 1) {
                this.parent.utils$removeWidget((GuiEventListener)this);
                this.parent.utils$modify();
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (!this.isValidClickButton(pButton)) {
            return false;
        }
        if (this.dragging) {
            this.dragging = false;
            this.draggingIndex = -1;
            return true;
        }
        return false;
    }

    public void captureOriginals(double pMouseX, double pMouseY) {
        this.oMouseX = pMouseX;
        this.oMouseY = pMouseY;
        this.oX = this.dX;
        this.oY = this.dY;
        this.oWidth = this.dWidth;
        this.oHeight = this.dHeight;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isMouseIn(double mouseX, double mouseY, double left, double top, double width, double height) {
        double right = left + width;
        double bottom = top + height;
        return mouseX > (double)this.left + left && mouseX <= (double)this.left + right && mouseY > (double)this.top + top && mouseY <= (double)this.top + bottom;
    }

    public boolean isMouseInDraggable(double mouseX, double mouseY, double x, double y) {
        return this.isMouseIn(mouseX, mouseY, x - 3.0, y - 3.0, 6.0, 6.0);
    }

    public void draw(GuiGraphics guiGraphics, double left, double top, double width, double height, int color) {
        guiGraphics.fill(this.left + (int)left, this.top + (int)top, this.left + (int)(left + width), this.top + (int)(top + height), color);
    }

    public void drawDraggable(GuiGraphics guiGraphics, double x, double y, int color) {
        guiGraphics.fill(this.left + (int)x - 3, this.top + (int)y - 3, this.left + (int)x + 3, this.top + (int)y + 3, -16777216);
        guiGraphics.fill(this.left + (int)x - 3 + 1, this.top + (int)y - 3 + 1, this.left + (int)x + 3 - 1, this.top + (int)y + 3 - 1, color);
    }

    public static Vector2d[] getDraggableCorners(double x, double y, double width, double height) {
        return new Vector2d[]{new Vector2d(x + width, y + height / 2.0), new Vector2d(x + width / 2.0, y + height), new Vector2d(x, y + height / 2.0), new Vector2d(x + width / 2.0, y), new Vector2d(x + width, y + height), new Vector2d(x + width, y), new Vector2d(x, y + height), new Vector2d(x, y)};
    }
}

