/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.gui.widget;

import de.maxhenkel.camera.TextureCache;
import dev.lucaargolo.utils.mixed.bookimages.ImageBookScreen;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BookImageWidget
extends AbstractWidget {
    protected final ImageBookScreen parent;
    protected final int page;
    protected final UUID image;
    protected int left;
    protected int top;

    public BookImageWidget(ImageBookScreen parent, int page, int pX, int pY, int pWidth, int pHeight, UUID image) {
        super(pX, pY, pWidth, pHeight, (Component)Component.empty());
        this.parent = parent;
        this.page = page;
        this.image = image;
    }

    public BookImageWidget(ImageBookScreen parent, int page, int pWidth, int pHeight, UUID image) {
        this(parent, page, 0, 0, pWidth, pHeight, image);
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.left = this.parent.utils$getWidgetLeft();
        this.top = this.parent.utils$getWidgetTop();
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.parent.utils$getCurrentPage() != this.page) {
            this.isHovered = false;
        } else {
            this.isHovered = this.isHoveredExtended(pMouseX, pMouseY, 0);
            ResourceLocation location = TextureCache.instance().getImage(this.image);
            if (location != null) {
                pGuiGraphics.blit(location, this.left + this.getX(), this.top + this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
            }
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
    }

    public int getPage() {
        return this.page;
    }

    public UUID getImage() {
        return this.image;
    }

    public boolean isHoveredExtended(double mouseX, double mouseY, int overflow) {
        return mouseX >= (double)(this.left + this.getX() - overflow) && mouseY >= (double)(this.top + this.getY() - overflow) && mouseX < (double)(this.left + this.getX() + this.getWidth() + overflow) && mouseY < (double)(this.top + this.getY() + this.getHeight() + overflow);
    }
}

