/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.gui;

import dev.lucaargolo.utils.menu.TitleMenu;
import dev.lucaargolo.utils.network.ServerboundSendTitlePacket;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class TitleMenuScreen
extends AbstractContainerScreen<TitleMenu> {
    private EditBox titleField;
    private EditBox subtitleField;
    private EditBox fadeInField;
    private EditBox stayField;
    private EditBox fadeOutField;
    private EditBox playersField;
    private Checkbox allPlayersCheckbox;

    public TitleMenuScreen(TitleMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 256;
        this.imageHeight = 205;
    }

    protected void init() {
        super.init();
        int startX = this.leftPos + 10;
        int startY = this.topPos + 20;
        int fieldWidth = 236;
        this.titleField = new EditBox(this.font, startX, startY, fieldWidth, 20, (Component)Component.literal((String)"Title"));
        this.titleField.setMaxLength(256);
        this.titleField.setHint((Component)Component.literal((String)"\u00a78T\u00edtulo"));
        this.addRenderableWidget((GuiEventListener)this.titleField);
        this.subtitleField = new EditBox(this.font, startX, startY + 38, fieldWidth, 20, (Component)Component.literal((String)"Subtitle"));
        this.subtitleField.setMaxLength(256);
        this.subtitleField.setHint((Component)Component.literal((String)"\u00a78Subt\u00edtulo"));
        this.addRenderableWidget((GuiEventListener)this.subtitleField);
        this.fadeInField = new EditBox(this.font, startX, startY + 75, 70, 20, (Component)Component.literal((String)"Fade In"));
        this.fadeInField.setMaxLength(5);
        this.fadeInField.setValue("10");
        this.fadeInField.setHint((Component)Component.literal((String)"Fade In"));
        this.addRenderableWidget((GuiEventListener)this.fadeInField);
        this.stayField = new EditBox(this.font, startX + 75, startY + 75, 70, 20, (Component)Component.literal((String)"Stay"));
        this.stayField.setMaxLength(5);
        this.stayField.setValue("70");
        this.stayField.setHint((Component)Component.literal((String)"Dura\u00e7\u00e3o"));
        this.addRenderableWidget((GuiEventListener)this.stayField);
        this.fadeOutField = new EditBox(this.font, startX + 150, startY + 75, 70, 20, (Component)Component.literal((String)"Fade Out"));
        this.fadeOutField.setMaxLength(5);
        this.fadeOutField.setValue("20");
        this.fadeOutField.setHint((Component)Component.literal((String)"Fade Out"));
        this.addRenderableWidget((GuiEventListener)this.fadeOutField);
        this.allPlayersCheckbox = Checkbox.builder((Component)Component.literal((String)"Todos os jogadores"), (Font)this.font).pos(startX, startY + 100).selected(true).onValueChange((checkbox, selected) -> {
            if (this.playersField != null) {
                this.playersField.setEditable(!selected);
            }
        }).build();
        this.addRenderableWidget((GuiEventListener)this.allPlayersCheckbox);
        this.playersField = new EditBox(this.font, startX, startY + 135, fieldWidth, 20, (Component)Component.literal((String)"Players"));
        this.playersField.setMaxLength(512);
        this.playersField.setHint((Component)Component.literal((String)"Jogadores (separados por v\u00edrgula)"));
        this.playersField.setEditable(false);
        this.addRenderableWidget((GuiEventListener)this.playersField);
        Button sendButton = Button.builder((Component)Component.literal((String)"Enviar"), button -> this.sendTitle()).bounds(startX, startY + 158, fieldWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)sendButton);
    }

    private void sendTitle() {
        int fadeOut;
        int stay;
        int fadeIn;
        String title = this.titleField.getValue();
        String subtitle = this.subtitleField.getValue();
        try {
            fadeIn = Integer.parseInt(this.fadeInField.getValue());
            stay = Integer.parseInt(this.stayField.getValue());
            fadeOut = Integer.parseInt(this.fadeOutField.getValue());
        }
        catch (NumberFormatException e) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.minecraft.player.displayClientMessage((Component)Component.literal((String)"\u00a7cValores num\u00e9ricos inv\u00e1lidos!"), false);
            }
            return;
        }
        boolean allPlayers = this.allPlayersCheckbox.selected();
        ArrayList<String> playerNames = new ArrayList<String>();
        if (!allPlayers) {
            String[] names;
            for (String name : names = this.playersField.getValue().split(",")) {
                String trimmed = name.trim();
                if (trimmed.isEmpty()) continue;
                playerNames.add(trimmed);
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSendTitlePacket(title, subtitle, fadeIn, stay, fadeOut, allPlayers, playerNames), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.closeContainer();
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.fill(this.leftPos, this.topPos, this.leftPos + this.imageWidth, this.topPos + this.imageHeight, -1072689136);
        guiGraphics.fill(this.leftPos + 1, this.topPos + 1, this.leftPos + this.imageWidth - 1, this.topPos + this.imageHeight - 1, -13092808);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int startX = this.leftPos + 10;
        int startY = this.topPos + 20;
        guiGraphics.drawString(this.font, "T\u00edtulo:", startX, startY - 12, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Subt\u00edtulo:", startX, startY + 25, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, "Tempos (em ticks):", startX, startY + 63, 0xFFFFFF, false);
        int playersLabelColor = this.allPlayersCheckbox.selected() ? 0x808080 : 0xFFFFFF;
        guiGraphics.drawString(this.font, "Jogadores:", startX, startY + 123, playersLabelColor, false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft != null && this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            if (this.titleField.isFocused() || this.subtitleField.isFocused() || this.fadeInField.isFocused() || this.stayField.isFocused() || this.fadeOutField.isFocused() || this.playersField.isFocused()) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

