/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.network.ServerboundSoundboardPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SoundboardScreen
extends Screen {
    private static final ResourceLocation TEXTURE = Utils.id("textures/gui/soundboard.png");
    private static final RandomSource RANDOM = RandomSource.create();
    @Nullable
    private static SoundboardScreen lastParent = null;
    private static String lastPrefix = "";
    private static List<String> lastNames = new ArrayList<String>();
    private final int BACKGROUND_WIDTH = 176;
    private final int BACKGROUND_HEIGHT = 176;
    private int leftPos = 0;
    private int topPos = 0;
    private int page = 0;
    @Nullable
    private final SoundboardScreen parent;
    private final String prefix;
    private final List<String> names;
    private final Map<String, Object> availableSounds;
    private final List<String> soundIndex = new ArrayList<String>();

    public static Map<String, Object> computeLast() {
        Map availableSounds = Utils.PROXY.getAvailableSounds();
        for (String name : lastNames) {
            Object object = availableSounds.get(name);
            if (object instanceof Map) {
                availableSounds = (Map)object;
                continue;
            }
            lastParent = null;
            lastPrefix = "";
            lastNames = new ArrayList<String>();
            break;
        }
        return availableSounds;
    }

    public SoundboardScreen() {
        this(SoundboardScreen.computeLast(), lastParent, lastPrefix, lastNames);
    }

    public SoundboardScreen(Map<String, Object> availableSounds, @Nullable SoundboardScreen parent, String prefix, List<String> names) {
        super((Component)Component.empty());
        this.availableSounds = availableSounds;
        this.soundIndex.addAll(availableSounds.keySet());
        this.sortSounds();
        this.parent = parent;
        this.prefix = prefix;
        this.names = names;
    }

    public void sortSounds() {
        this.soundIndex.sort((s1, s2) -> {
            boolean isS1Sound = this.availableSounds.get(s1) instanceof String;
            boolean isS2Sound = this.availableSounds.get(s2) instanceof String;
            List<String> favoriteSounds = Utils.PROXY.getFavoriteSounds();
            boolean isS1Favorite = favoriteSounds.contains(this.prefix + s1);
            boolean isS2Favorite = favoriteSounds.contains(this.prefix + s2);
            if (isS1Sound && !isS2Sound) {
                return 1;
            }
            if (!isS1Sound && isS2Sound) {
                return -1;
            }
            if (isS1Favorite && !isS2Favorite) {
                return -1;
            }
            if (!isS1Favorite && isS2Favorite) {
                return 1;
            }
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        });
    }

    public void init() {
        super.init();
        Objects.requireNonNull(this);
        this.leftPos = (this.width - 176) / 2;
        Objects.requireNonNull(this);
        this.topPos = (this.height - 176) / 2;
        this.topPos -= 4;
    }

    public void onClose() {
        super.onClose();
        lastParent = this.parent;
        lastPrefix = this.prefix;
        lastNames = this.names;
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        List<String> playingSounds = Utils.PROXY.getPlayingSounds();
        List<String> favoriteSounds = Utils.PROXY.getFavoriteSounds();
        int availablePages = this.availableSounds.size() / 42 + 1;
        this.page = Math.min(this.page, availablePages - 1);
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        pGuiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, 176, 176);
        if (this.parent != null) {
            if (pMouseX >= this.leftPos + 5 && pMouseX <= this.leftPos + 5 + 18 && pMouseY >= this.topPos + 5 && pMouseY <= this.topPos + 5 + 10) {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 5, this.topPos + 5, 18, 217, 18, 10);
            } else {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 5, this.topPos + 5, 0, 217, 18, 10);
            }
        }
        if (this.page > 0) {
            if (pMouseX >= this.leftPos + 5 && pMouseX <= this.leftPos + 5 + 18 && pMouseY >= this.topPos + 160 && pMouseY <= this.topPos + 160 + 10) {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 5, this.topPos + 160, 18, 207, 18, 10);
            } else {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 5, this.topPos + 160, 0, 207, 18, 10);
            }
        }
        if (this.page < availablePages - 1) {
            if (pMouseX >= this.leftPos + 152 && pMouseX <= this.leftPos + 152 + 18 && pMouseY >= this.topPos + 160 && pMouseY <= this.topPos + 160 + 10) {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 152, this.topPos + 160, 18, 197, 18, 10);
            } else {
                pGuiGraphics.blit(TEXTURE, this.leftPos + 152, this.topPos + 160, 0, 197, 18, 10);
            }
        }
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 7; ++col) {
                int index = col + row * 7 + this.page * 42;
                if (index >= this.availableSounds.size()) continue;
                String name = this.soundIndex.get(index);
                boolean folder = this.availableSounds.get(name) instanceof Map;
                if (folder) {
                    pGuiGraphics.blit(TEXTURE, this.leftPos + 8 + col * 23, this.topPos + 20 + row * 23, 42, 197, 21, 21);
                } else {
                    boolean playing = playingSounds.contains(this.prefix + name);
                    RANDOM.setSeed((long)name.hashCode());
                    int offset = playing ? 8 : RANDOM.nextInt(0, 8);
                    pGuiGraphics.blit(TEXTURE, this.leftPos + 8 + col * 23, this.topPos + 20 + row * 23, offset * 21, 176, 21, 21);
                }
                boolean favorite = favoriteSounds.contains(this.prefix + name);
                if (favorite) {
                    pGuiGraphics.blit(TEXTURE, this.leftPos + 8 + col * 23, this.topPos + 20 + row * 23, 63, 197, 21, 21);
                }
                if (pMouseX < this.leftPos + 8 + col * 23 || pMouseX > this.leftPos + 8 + col * 23 + 21 || pMouseY < this.topPos + 20 + row * 23 || pMouseY > this.topPos + 20 + row * 23 + 21) continue;
                pGuiGraphics.fill(this.leftPos + 8 + col * 23, this.topPos + 20 + row * 23, this.leftPos + 8 + col * 23 + 21, this.topPos + 20 + row * 23 + 21, -2130706433);
                pGuiGraphics.renderTooltip(this.font, (Component)Component.literal((String)name), pMouseX, pMouseY);
            }
        }
        String title = "Soundboard";
        int w0 = this.font.width(title);
        pGuiGraphics.drawString(this.font, title, this.leftPos + 88 - w0 / 2, this.topPos + 7, 0xFFFFFF, false);
        String tip = "Right click to mark as favorite.";
        int w1 = this.font.width(tip);
        pGuiGraphics.drawString(this.font, tip, this.leftPos + 88 - w1 / 2, this.topPos + 176 + 4, 0xFFFFFF, false);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.minecraft == null) {
            return false;
        }
        if (pButton != 0 && pButton != 1) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        if (pButton == 0 && this.parent != null && pMouseX >= (double)(this.leftPos + 5) && pMouseX <= (double)(this.leftPos + 5 + 18) && pMouseY >= (double)(this.topPos + 5) && pMouseY <= (double)(this.topPos + 5 + 10)) {
            this.minecraft.setScreen((Screen)this.parent);
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        int availablePages = this.availableSounds.size() / 42 + 1;
        this.page = Math.min(this.page, availablePages - 1);
        if (pButton == 0 && this.page > 0 && pMouseX >= (double)(this.leftPos + 5) && pMouseX <= (double)(this.leftPos + 5 + 18) && pMouseY >= (double)(this.topPos + 160) && pMouseY <= (double)(this.topPos + 160 + 10)) {
            --this.page;
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        if (pButton == 0 && this.page < availablePages - 1 && pMouseX >= (double)(this.leftPos + 152) && pMouseX <= (double)(this.leftPos + 152 + 18) && pMouseY >= (double)(this.topPos + 160) && pMouseY <= (double)(this.topPos + 160 + 10)) {
            ++this.page;
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 7; ++col) {
                Object object;
                int index = col + row * 7 + this.page * 42;
                if (index >= this.availableSounds.size()) continue;
                String name = this.soundIndex.get(index);
                if (!(pMouseX >= (double)(this.leftPos + 8 + col * 23)) || !(pMouseX <= (double)(this.leftPos + 8 + col * 23 + 21)) || !(pMouseY >= (double)(this.topPos + 20 + row * 23)) || !(pMouseY <= (double)(this.topPos + 20 + row * 22 + 22))) continue;
                if (pButton == 0 && (object = this.availableSounds.get(name)) instanceof Map) {
                    Map innerMap = (Map)object;
                    ArrayList<String> newNames = new ArrayList<String>(this.names);
                    newNames.add(name);
                    this.minecraft.setScreen((Screen)new SoundboardScreen(innerMap, this, this.prefix + name + Utils.PROXY.getServerSeparatorChar(), newNames));
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSoundboardPacket(this.prefix + name, pButton == 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                }
                return true;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

