/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.gui;

import dev.lucaargolo.utils.client.misc.HTTPCubeMapHandler;
import dev.lucaargolo.utils.network.ServerboundSkyConfigPacket;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkyConfigScreen
extends Screen {
    @NotNull
    private final BlockPos pos;
    private final EditBox[] editBoxes = new EditBox[6];
    private HTTPCubeMapHandler.CubeMap.Format initialFormat;
    private String[] initialLinks;
    private Double initialScale;
    private CycleButton<HTTPCubeMapHandler.CubeMap.Format> typeButton;
    private Button doneButton;
    private ExtendedSlider scaleSlider;

    public SkyConfigScreen(@NotNull BlockPos pos, HTTPCubeMapHandler.CubeMap.Format format, String[] links, float scale) {
        super((Component)Component.literal((String)"Sky Config"));
        this.pos = pos;
        this.initialFormat = format;
        this.initialLinks = links;
        this.initialScale = scale;
    }

    protected void init() {
        this.typeButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(format -> Component.literal((String)format.getSerializedName())).displayOnlyValue().withInitialValue((Object)(this.initialFormat != null ? this.initialFormat : (this.typeButton != null ? (HTTPCubeMapHandler.CubeMap.Format)((Object)this.typeButton.getValue()) : HTTPCubeMapHandler.CubeMap.Format.CROSS))).withValues((Object[])HTTPCubeMapHandler.CubeMap.Format.values()).create(this.width / 2 - 80, 20, 160, 20, (Component)Component.empty(), (button, value) -> {
            for (int i = 0; i < this.editBoxes.length; ++i) {
                if (this.isSeparate()) {
                    this.scaleSlider.setPosition(this.width / 2 - 80, 180);
                    this.doneButton.setPosition(this.width / 2 - 80, 200);
                    this.editBoxes[i].active = true;
                    this.editBoxes[i].visible = true;
                    continue;
                }
                if (i <= 0) continue;
                this.scaleSlider.setPosition(this.width / 2 - 80, 80);
                this.doneButton.setPosition(this.width / 2 - 80, 100);
                this.editBoxes[i].active = false;
                this.editBoxes[i].visible = false;
            }
        }));
        for (int i = 0; i < this.editBoxes.length; ++i) {
            String previousValue = this.initialLinks != null ? this.initialLinks[i] : (this.editBoxes[i] != null ? this.editBoxes[i].getValue() : "");
            this.editBoxes[i] = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 80, 50 + i * 20, 160, 20, (Component)Component.empty()));
            this.editBoxes[i].setMaxLength(32373);
            this.editBoxes[i].setValue(previousValue);
            if (this.isSeparate() || i <= 0) continue;
            this.editBoxes[i].active = false;
            this.editBoxes[i].visible = false;
        }
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"Done"), button -> {
            String[] links = new String[this.editBoxes.length];
            for (int i = 0; i < this.editBoxes.length; ++i) {
                links[i] = i == 0 || this.isSeparate() ? this.editBoxes[i].getValue() : "";
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSkyConfigPacket(this.pos, (HTTPCubeMapHandler.CubeMap.Format)((Object)((Object)this.typeButton.getValue())), links, (float)this.scaleSlider.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }).bounds(this.width / 2 - 80, this.isSeparate() ? 200 : 100, 160, 20).build());
        this.scaleSlider = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)new ExtendedSlider(this.width / 2 - 80, this.isSeparate() ? 180 : 80, 160, 20, (Component)Component.literal((String)"Scale: "), (Component)Component.empty(), 1.0, 512.0, this.initialScale != null ? this.initialScale : (this.scaleSlider != null ? this.scaleSlider.getValue() : 1.0), 1.0, 0, true));
        this.initialFormat = null;
        this.initialLinks = null;
        this.initialScale = null;
    }

    private boolean isSeparate() {
        return ((HTTPCubeMapHandler.CubeMap.Format)((Object)this.typeButton.getValue())).equals((Object)HTTPCubeMapHandler.CubeMap.Format.SEPARATE);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

