/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.gui;

import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.menu.InvSeeMenu;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ScreenOpen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvSeeScreen
extends AbstractContainerScreen<InvSeeMenu> {
    public static final ResourceLocation TEXTURE = Utils.id("textures/gui/invsee.png");
    public static final ResourceLocation HEART_CONTAINER = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/container.png");
    public static final ResourceLocation HEART_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/full.png");
    public static final ResourceLocation ARMOR_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/armor_full.png");
    private final Player player;
    private Button playerAccessoriesButton;
    @Nullable
    private final Player otherPlayer;
    private Button otherPlayerAccessoriesButton;
    private float xMouse;
    private float yMouse;

    public InvSeeScreen(InvSeeMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 356;
        this.imageHeight = 166;
        this.player = menu.getPlayer();
        this.otherPlayer = menu.getOtherPlayer();
    }

    protected void init() {
        super.init();
        this.playerAccessoriesButton = Button.builder((Component)Component.literal((String)"Accessories"), button -> AccessoriesNetworking.sendToServer((Record)ScreenOpen.of((boolean)false, (AccessoriesMenuVariant)AccessoriesMenuVariant.ORIGINAL))).bounds(this.leftPos + 76, this.topPos + 41, 93, 18).build();
        this.addRenderableWidget((GuiEventListener)this.playerAccessoriesButton);
        this.otherPlayerAccessoriesButton = Button.builder((Component)Component.literal((String)"Accessories"), button -> {
            if (this.otherPlayer != null) {
                AccessoriesNetworking.sendToServer((Record)ScreenOpen.of((LivingEntity)this.otherPlayer, (AccessoriesMenuVariant)AccessoriesMenuVariant.ORIGINAL));
            }
        }).bounds(this.leftPos + 76 + 180, this.topPos + 41, 93, 18).build();
        this.addRenderableWidget((GuiEventListener)this.otherPlayerAccessoriesButton);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderPlayerBg(guiGraphics, this.player, 0);
        this.renderPlayerBg(guiGraphics, this.otherPlayer, 180);
    }

    private void renderPlayerBg(@NotNull GuiGraphics guiGraphics, @Nullable Player player, int xOffset) {
        guiGraphics.blit(TEXTURE, this.leftPos + xOffset, this.topPos, 0, 0, 176, 166);
        guiGraphics.fill(this.leftPos + 76 + xOffset, this.topPos + 7, this.leftPos + 76 + 95 + xOffset, this.topPos + 7 + 54, -3750202);
        guiGraphics.blit(HEART_CONTAINER, this.leftPos + 78 + xOffset, this.topPos + 18, 0.0f, 0.0f, 9, 9, 9, 9);
        guiGraphics.blit(HEART_FULL, this.leftPos + 78 + xOffset, this.topPos + 18, 0.0f, 0.0f, 9, 9, 9, 9);
        guiGraphics.blit(ARMOR_FULL, this.leftPos + 78 + xOffset, this.topPos + 28, 0.0f, 0.0f, 9, 9, 9, 9);
        if (player != null) {
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 26 + xOffset), (int)(this.topPos + 8), (int)(this.leftPos + 75 + xOffset), (int)(this.topPos + 78), (int)30, (float)0.0625f, (float)this.xMouse, (float)this.yMouse, (LivingEntity)player);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderPlayerFg(guiGraphics, this.player, 0);
        this.renderPlayerFg(guiGraphics, this.otherPlayer, 180);
    }

    private void renderPlayerFg(@NotNull GuiGraphics guiGraphics, @Nullable Player player, int xOffset) {
        guiGraphics.drawString(this.font, (Component)(player != null ? player.getDisplayName() : Component.literal((String)"Too far away")), 78 + xOffset, 8, 0x404040, false);
        guiGraphics.drawString(this.font, (String)(player != null ? player.getHealth() + "/" + player.getMaxHealth() : "?/?"), 89 + xOffset, 19, 0x404040, false);
        guiGraphics.drawString(this.font, (String)(player != null ? "" + player.getArmorValue() : "?"), 89 + xOffset, 29, 0x404040, false);
    }
}

