/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client.blockentity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.blockentity.SkyBlockEntity;
import dev.lucaargolo.utils.client.misc.HTTPCubeMapHandler;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkyBlockEntityRenderer
implements BlockEntityRenderer<SkyBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public SkyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull SkyBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int glId = HTTPCubeMapHandler.get(blockEntity.getFormat(), blockEntity.getLinks());
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(blockEntity.getScale(), blockEntity.getScale(), blockEntity.getScale());
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        SkyBlockEntityRenderer.renderBox(glId, poseStack.last());
        poseStack.popPose();
        RenderSystem.disableDepthTest();
        RenderSystem.enableCull();
    }

    public boolean shouldRenderOffScreen(@NotNull SkyBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 4098;
    }

    public boolean shouldRender(@NotNull SkyBlockEntity blockEntity, @NotNull Vec3 cameraPos) {
        return true;
    }

    private static void renderBox(int glId, PoseStack.Pose pose) {
        RenderSystem.setShader(() -> Utils.ClientEvents.SKYBOX_SHADER);
        RenderSystem.setShaderTexture((int)0, (int)glId);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        SkyBlockEntityRenderer.addQuads(buffer, pose);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    private static void addQuads(BufferBuilder buffer, PoseStack.Pose pose) {
        buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 1.0f, 0.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 1.0f, 0.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 0.0f, 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 0.0f, 1.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 0.0f, 1.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 1.0f, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 1.0f, 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 0.0f, 1.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 0.0f, 0.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 0.0f, 1.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 0.0f, 1.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 0.0f, 1.0f, 0.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 0.0f, 1.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 0.0f, 0.0f).setUv(0.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 1.0f, 0.0f).setUv(1.0f, 1.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(pose, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

