/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.client;

import dev.lucaargolo.utils.CommonProxy;
import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.client.gui.SkyConfigScreen;
import dev.lucaargolo.utils.client.gui.SoundboardScreen;
import dev.lucaargolo.utils.client.gui.widget.ResizeableImageWidget;
import dev.lucaargolo.utils.client.misc.HTTPCubeMapHandler;
import dev.lucaargolo.utils.data.ColorfulSkyData;
import dev.lucaargolo.utils.data.FakeNameData;
import dev.lucaargolo.utils.data.FakeSkinData;
import dev.lucaargolo.utils.mixed.bookimages.ImageBookScreen;
import dev.lucaargolo.utils.mixed.bookimages.SpreadImageBookScreen;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private final ColorfulSkyData colorfulSky = new ColorfulSkyData();
    public Map<String, Object> availableSounds = new HashMap<String, Object>();
    public List<String> playingSounds = new ArrayList<String>();
    public List<String> favoriteSounds = new ArrayList<String>();
    private char serverSeparatorChar = File.separatorChar;
    private FakeNameData fakeNameData = new FakeNameData();
    private FakeSkinData fakeSkinData = new FakeSkinData();

    @Override
    public ColorfulSkyData getColorfulSky() {
        return this.colorfulSky;
    }

    @Override
    public Map<String, Object> getAvailableSounds() {
        return this.availableSounds;
    }

    @Override
    public void setAvailableSounds(Map<String, Object> sounds) {
        this.availableSounds = sounds;
    }

    @Override
    public List<String> getPlayingSounds() {
        return this.playingSounds;
    }

    @Override
    public void setPlayingSounds(List<String> sounds) {
        this.playingSounds = sounds;
    }

    @Override
    public void addBookImage(UUID id, int width, int height) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof ImageBookScreen) {
            ImageBookScreen screen2 = (ImageBookScreen)screen;
            scaled = Utils.getScaledDimension(width, height, screen2.utils$getBookWidth(), screen2.utils$getBookHeight());
            ResizeableImageWidget widget = new ResizeableImageWidget(screen2, screen2.utils$getCurrentPage(), scaled.x, scaled.y, id);
            screen2.utils$addWidget(widget);
            screen2.utils$modify();
        } else {
            scaled = minecraft.screen;
            if (scaled instanceof SpreadImageBookScreen) {
                SpreadImageBookScreen spread = (SpreadImageBookScreen)scaled;
                ImageBookScreen screen3 = spread.utils$isLeftScreenFocused() ? spread.utils$getLeftScreen() : spread.utils$getRightScreen();
                Vector2i scaled = Utils.getScaledDimension(width, height, screen3.utils$getBookWidth(), screen3.utils$getBookHeight());
                ResizeableImageWidget widget = new ResizeableImageWidget(screen3, screen3.utils$getCurrentPage(), scaled.x, scaled.y, id);
                screen3.utils$addWidget(widget);
                screen3.utils$modify();
            }
        }
    }

    @Override
    public List<String> getFavoriteSounds() {
        return this.favoriteSounds;
    }

    @Override
    public void setFavoriteSounds(List<String> sounds) {
        this.favoriteSounds = sounds;
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof SoundboardScreen) {
            SoundboardScreen screen2 = (SoundboardScreen)screen;
            screen2.sortSounds();
        }
    }

    @Override
    public char getServerSeparatorChar() {
        return this.serverSeparatorChar;
    }

    @Override
    public void setServerSeparatorChar(char serverSeparatorChar) {
        this.serverSeparatorChar = serverSeparatorChar;
    }

    @Override
    @Nullable
    public FakeNameData getFakeNameData() {
        return this.fakeNameData;
    }

    @Override
    public void setFakeNameData(FakeNameData fakeNameData) {
        this.fakeNameData = fakeNameData;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null) {
            minecraft.level.players().forEach(Player::refreshDisplayName);
        }
    }

    @Override
    public void openSkyConfigScreen(BlockPos pos, HTTPCubeMapHandler.CubeMap.Format format, String[] links, float scale) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.setScreen((Screen)new SkyConfigScreen(pos, format, links, scale));
    }

    @Override
    @Nullable
    public FakeSkinData getFakeSkinData() {
        return this.fakeSkinData;
    }

    @Override
    public void setFakeSkinData(FakeSkinData fakeSkinData) {
        this.fakeSkinData = fakeSkinData;
        try {
            Class<?> ignSkinClass = Class.forName("journeymap.client.texture.IgnSkin");
            Field cacheField = ignSkinClass.getDeclaredField("faceImageCache");
            cacheField.setAccessible(true);
            Map faceImageCache = (Map)cacheField.get(null);
            faceImageCache.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

