/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.blockentity;

import dev.lucaargolo.utils.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.utils.client.misc.HTTPCubeMapHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkyBlockEntity
extends BlockEntity {
    private HTTPCubeMapHandler.CubeMap.Format format = HTTPCubeMapHandler.CubeMap.Format.CROSS;
    private String[] links = new String[]{"", "", "", "", "", ""};
    private float scale = 1.0f;

    public SkyBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.SKY.get(), pos, blockState);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Type", this.format.ordinal());
        for (int i = 0; i < this.links.length; ++i) {
            tag.putString("Link" + i, this.links[i]);
        }
        tag.putFloat("Scale", this.scale);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.format = HTTPCubeMapHandler.CubeMap.Format.values()[tag.getInt("Type")];
        for (int i = 0; i < this.links.length; ++i) {
            this.links[i] = tag.getString("Link" + i);
        }
        this.scale = tag.getFloat("Scale");
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setFormat(HTTPCubeMapHandler.CubeMap.Format format) {
        this.format = format;
        this.setChanged();
    }

    public HTTPCubeMapHandler.CubeMap.Format getFormat() {
        return this.format;
    }

    public void setLinks(String[] links) {
        this.links = links;
        this.setChanged();
    }

    public String[] getLinks() {
        return this.links;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setChanged();
    }

    public float getScale() {
        return this.scale;
    }
}

