/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.attachment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record BalloonHistoryAttachment(List<Message> messages) {
    public static StreamCodec<RegistryFriendlyByteBuf, BalloonHistoryAttachment> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, Message.STREAM_CODEC), BalloonHistoryAttachment::messages, BalloonHistoryAttachment::new);

    public BalloonHistoryAttachment add(Component component) {
        int minTtl = 0;
        for (Message m : this.messages) {
            if (m.ttl <= minTtl) continue;
            minTtl = m.ttl;
        }
        int ttl = Math.max(200, minTtl) + BalloonHistoryAttachment.ttl(component);
        this.messages.add(new Message(component, ttl));
        return this;
    }

    public boolean tick() {
        Iterator<Message> iterator = this.messages.iterator();
        boolean dirty = false;
        while (iterator.hasNext()) {
            Message message = iterator.next();
            if (!message.tick()) continue;
            iterator.remove();
            dirty = true;
        }
        return dirty;
    }

    public static BalloonHistoryAttachment create() {
        return new BalloonHistoryAttachment(new ArrayList<Message>());
    }

    private static int ttl(Component component) {
        String string = component.getString();
        String[] words = string.split(" ");
        return Math.min(words.length * 10, 200);
    }

    public static class Message {
        public static StreamCodec<RegistryFriendlyByteBuf, Message> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, Message::component, (StreamCodec)ByteBufCodecs.VAR_INT, Message::timeToLive, Message::new);
        private final Component component;
        private int ttl;

        public Message(Component component, int ttl) {
            this.component = component;
            this.ttl = ttl;
        }

        public Component component() {
            return this.component;
        }

        public int timeToLive() {
            return this.ttl;
        }

        public boolean tick() {
            return --this.ttl <= 0;
        }
    }
}

