/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.logging.LogUtils;
import dev.lucaargolo.arkanis_backpacks.ArkanisBackpacks;
import dev.lucaargolo.utils.CommonProxy;
import dev.lucaargolo.utils.attachment.ModAttachments;
import dev.lucaargolo.utils.block.ModBlocks;
import dev.lucaargolo.utils.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.utils.client.ClientProxy;
import dev.lucaargolo.utils.client.blockentity.SkyBlockEntityRenderer;
import dev.lucaargolo.utils.client.misc.HTTPCubeMapHandler;
import dev.lucaargolo.utils.data.ModDataComponentTypes;
import dev.lucaargolo.utils.item.ModCreativeTabs;
import dev.lucaargolo.utils.item.ModItems;
import dev.lucaargolo.utils.menu.ModMenus;
import dev.lucaargolo.utils.network.ClientboundBookImagePacket;
import dev.lucaargolo.utils.network.ClientboundColorfulSkyPacket;
import dev.lucaargolo.utils.network.ClientboundFakeNameDataPacket;
import dev.lucaargolo.utils.network.ClientboundFakeSkinDataPacket;
import dev.lucaargolo.utils.network.ClientboundSoundboardPacket;
import dev.lucaargolo.utils.network.ServerboundBookImagePacket;
import dev.lucaargolo.utils.network.ServerboundBookImagesPacket;
import dev.lucaargolo.utils.network.ServerboundSendTitlePacket;
import dev.lucaargolo.utils.network.ServerboundSkyConfigPacket;
import dev.lucaargolo.utils.network.ServerboundSoundboardPacket;
import dev.lucaargolo.utils.sound.ModSounds;
import java.io.IOException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.joml.Vector2i;
import org.slf4j.Logger;

@Mod(value="utils")
public class Utils {
    public static final String MOD_ID = "utils";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CommonProxy PROXY;

    public Utils(IEventBus modEventBus, ModContainer modContainer) {
        ModDataComponentTypes.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntityTypes.register(modEventBus);
        ModItems.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModSounds.register(modEventBus);
        ModMenus.register(modEventBus);
        ModAttachments.register(modEventBus);
        new ArkanisBackpacks(modEventBus, modContainer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static CommonProxy clientProxy() {
        return new ClientProxy();
    }

    public static CommonProxy commonProxy() {
        return new CommonProxy();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static Vector2i getScaledDimension(int originalWidth, int originalHeight, int boundWidth, int boundHeight) {
        int newWidth = originalWidth;
        int newHeight = originalHeight;
        if (originalWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originalHeight / originalWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originalWidth / originalHeight;
        }
        return new Vector2i(newWidth, newHeight);
    }

    static {
        Dist dist = FMLLoader.getDist();
        PROXY = dist == Dist.CLIENT ? Utils.clientProxy() : Utils.commonProxy();
    }

    @EventBusSubscriber(modid="utils", value={Dist.CLIENT})
    @OnlyIn(value=Dist.CLIENT)
    public static class ClientEvents {
        public static final Lazy<KeyMapping> SOUNDBOARD_KEY = Lazy.of(() -> new KeyMapping("key.utils.soundboard", 89, "key.utils.admin"));
        public static ShaderInstance SKYBOX_SHADER;

        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)SOUNDBOARD_KEY.get());
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.SKY.get(), SkyBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerShaders(RegisterShadersEvent event) throws IOException {
            HTTPCubeMapHandler.load();
            event.registerShader(new ShaderInstance(event.getResourceProvider(), Utils.id("skybox"), DefaultVertexFormat.POSITION_TEX_COLOR), instance -> {
                SKYBOX_SHADER = instance;
            });
        }
    }

    @EventBusSubscriber(modid="utils")
    public static class Events {
        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToClient(ClientboundBookImagePacket.TYPE, ClientboundBookImagePacket.STREAM_CODEC, ClientboundBookImagePacket::handleClient);
            registrar.playToClient(ClientboundColorfulSkyPacket.TYPE, ClientboundColorfulSkyPacket.STREAM_CODEC, ClientboundColorfulSkyPacket::handleClient);
            registrar.playToClient(ClientboundSoundboardPacket.TYPE, ClientboundSoundboardPacket.STREAM_CODEC, ClientboundSoundboardPacket::handleClient);
            registrar.playToClient(ClientboundFakeNameDataPacket.TYPE, ClientboundFakeNameDataPacket.STREAM_CODEC, ClientboundFakeNameDataPacket::handleClient);
            registrar.playToClient(ClientboundFakeSkinDataPacket.TYPE, ClientboundFakeSkinDataPacket.STREAM_CODEC, ClientboundFakeSkinDataPacket::handleClient);
            registrar.playToServer(ServerboundBookImagePacket.TYPE, StreamCodec.unit((Object)new ServerboundBookImagePacket()), ServerboundBookImagePacket::handleServer);
            registrar.playToServer(ServerboundBookImagesPacket.TYPE, ServerboundBookImagesPacket.STREAM_CODEC, ServerboundBookImagesPacket::handleServer);
            registrar.playToServer(ServerboundSendTitlePacket.TYPE, ServerboundSendTitlePacket.STREAM_CODEC, ServerboundSendTitlePacket::handleServer);
            registrar.playToServer(ServerboundSoundboardPacket.TYPE, ServerboundSoundboardPacket.STREAM_CODEC, ServerboundSoundboardPacket::handleServer);
            registrar.playToServer(ServerboundSkyConfigPacket.TYPE, ServerboundSkyConfigPacket.STREAM_CODEC, ServerboundSkyConfigPacket::handleServer);
        }
    }
}

