/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils;

import com.mojang.brigadier.CommandDispatcher;
import dev.lucaargolo.utils.attachment.BalloonHistoryAttachment;
import dev.lucaargolo.utils.attachment.ModAttachments;
import dev.lucaargolo.utils.commands.ArkHelpCommand;
import dev.lucaargolo.utils.commands.ArkLoreCommand;
import dev.lucaargolo.utils.commands.BalloonCommand;
import dev.lucaargolo.utils.commands.ColorfulSkyCommand;
import dev.lucaargolo.utils.commands.FakeNameCommand;
import dev.lucaargolo.utils.commands.FakeSkinCommand;
import dev.lucaargolo.utils.commands.FlyCommand;
import dev.lucaargolo.utils.commands.GodCommand;
import dev.lucaargolo.utils.commands.InvSeeCommand;
import dev.lucaargolo.utils.commands.SoundboardCommand;
import dev.lucaargolo.utils.commands.TitleCommand;
import dev.lucaargolo.utils.data.BalloonModeData;
import dev.lucaargolo.utils.data.ColorfulSkyData;
import dev.lucaargolo.utils.data.FakeNameData;
import dev.lucaargolo.utils.data.FakeSkinData;
import dev.lucaargolo.utils.misc.SoundBoard;
import io.github.ladysnake.pal.VanillaAbilities;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import redstonedubstep.mods.vanishmod.VanishUtil;

@EventBusSubscriber(modid="utils")
public class CommonEvents {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ColorfulSkyCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SoundboardCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        FakeNameCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        FakeSkinCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        BalloonCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        InvSeeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        FlyCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        GodCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ArkHelpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ArkLoreCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TitleCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        event.getServer().getPlayerList().getPlayers().forEach(SoundBoard::tickPlayer);
        SoundBoard.tick(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerChat(ServerChatEvent event) {
        ServerPlayer player;
        BalloonModeData data = BalloonModeData.get(event.getPlayer().server);
        if (data.isActive(player = event.getPlayer())) {
            BalloonHistoryAttachment history = (BalloonHistoryAttachment)player.getData(ModAttachments.BALLOON_HISTORY);
            player.setData(ModAttachments.BALLOON_HISTORY, (Object)history.add(event.getMessage()));
            player.displayClientMessage((Component)Component.literal((String)"[Balloon] ").withStyle(ChatFormatting.GRAY).append((Component)event.getMessage().copy().withStyle(ChatFormatting.WHITE)), false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SoundBoard.updatePlayer(player2);
            ColorfulSkyData colorfulSkyData = ColorfulSkyData.get(player2.server);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)colorfulSkyData.getPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            FakeNameData fakeNameData = FakeNameData.get(player2.server);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)fakeNameData.getPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            FakeSkinData fakeSkinData = FakeSkinData.get(player2.server);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)fakeSkinData.getPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onTabListName(PlayerEvent.TabListNameFormat event) {
        Component name;
        Object object = name = event.getDisplayName() == null ? PlayerTeam.formatNameForTeam((Team)event.getEntity().getTeam(), (Component)event.getEntity().getName()) : event.getDisplayName();
        if (VanishUtil.isVanished((Player)event.getEntity())) {
            name = Component.literal((String)"\u00a7aV\u00a7r ").append(name);
        }
        event.setDisplayName(name);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BalloonHistoryAttachment history = (BalloonHistoryAttachment)player.getData(ModAttachments.BALLOON_HISTORY);
            if (history.tick()) {
                player.setData(ModAttachments.BALLOON_HISTORY, (Object)history);
            }
            ArrayList<MutableComponent> message = new ArrayList<MutableComponent>();
            if (GodCommand.GOD.grants((Player)player, VanillaAbilities.INVULNERABLE)) {
                message.add(Component.literal((String)"You're in god mode!").withStyle(ChatFormatting.RED));
            }
            if (VanishUtil.isVanished((Player)player)) {
                message.add(Component.literal((String)"You're currently vanished!").withStyle(ChatFormatting.GREEN));
            }
            if (!BalloonModeData.get(player.server).isActive(player)) {
                message.add(Component.literal((String)"You're not in balloon mode!").withStyle(ChatFormatting.GRAY));
            }
            if (!message.isEmpty()) {
                MutableComponent component = Component.empty();
                for (int i = 0; i < message.size(); ++i) {
                    component = component.append((Component)message.get(i));
                    if (i >= message.size() - 1) continue;
                    component = component.append("\n");
                }
                event.getEntity().displayClientMessage((Component)component, true);
            }
        }
    }
}

