/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.config;

import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CACCommonConfig {
    public final ModConfigSpec.DoubleValue necklaceGuardianDebuff;
    public final ModConfigSpec.DoubleValue necklaceDrownedDebuff;
    public final ModConfigSpec.DoubleValue necklaceSwimSpeed;
    public final ModConfigSpec.DoubleValue grapplingHookSpeed;
    public final ModConfigSpec.DoubleValue grapplingHookMaxSpeed;
    public final ModConfigSpec.DoubleValue grapplingHookMaxDistance;

    public double necklaceRangeDebuff(EntityType<?> type, int level) {
        if (type == EntityType.GUARDIAN && level > 1) {
            return this.necklaceGuardianDebuff.getAsDouble() * (double)level;
        }
        if (type == EntityType.DROWNED) {
            return this.necklaceDrownedDebuff.getAsDouble() * (double)level;
        }
        return 0.0;
    }

    public CACCommonConfig(ModConfigSpec.Builder builder) {
        builder.push("necklace");
        this.necklaceSwimSpeed = builder.defineInRange("swim_sped", (double)0.2f, 0.0, 1.0);
        this.necklaceDrownedDebuff = builder.defineInRange("drowned_range_debuff", (double)0.1f, 0.0, 1.0);
        this.necklaceGuardianDebuff = builder.defineInRange("guardian_range_debuff", (double)0.1f, 0.0, 1.0);
        builder.pop();
        builder.push("grappling_hook");
        this.grapplingHookSpeed = builder.defineInRange("launch_speed", 1.0, 0.0, 10.0);
        this.grapplingHookMaxSpeed = builder.defineInRange("max_speed", 4.0, 1.0, 1000.0);
        this.grapplingHookMaxDistance = builder.defineInRange("max_distance", 32.0, 4.0, 128.0);
        builder.pop();
    }
}

