/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.zap;

import com.github.teamfusion.rottencreatures.common.level.entities.immortal.Immortal;
import com.github.teamfusion.rottencreatures.common.level.entities.zap.goal.ZapFollowLeaderGoal;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.common.registries.RCMobEffects;
import com.github.teamfusion.rottencreatures.core.data.tags.RCEntityTypeTags;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Zap
extends Zombie {
    public Zap(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 22.0).add(Attributes.FOLLOW_RANGE, 50.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 2.0);
    }

    protected void addBehaviourGoals() {
        super.addBehaviourGoals();
        this.goalSelector.addGoal(1, (Goal)new ZapFollowLeaderGoal((PathfinderMob)this, Immortal.class, 1.25));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<Zombie>(this, (Mob)this, Zombie.class, true){

            public boolean canUse() {
                return super.canUse() && this.target != null && !this.target.getType().is(RCEntityTypeTags.IMMORTAL_IGNORE);
            }
        });
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        if (hurt && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            living.addEffect(new MobEffectInstance((Holder)RCMobEffects.CHANNELLED.getHolder().get(), 140 * (int)modifier), (Entity)this);
            Zap.convertToZap((LivingEntity)this, living);
        }
        return hurt;
    }

    protected void doPush(Entity entity) {
        super.doPush(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Zap.convertToZap((LivingEntity)this, living);
        }
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source == this.damageSources().lightningBolt()) {
            this.setHealth(this.getMaxHealth());
            return false;
        }
        return super.hurt(source, amount);
    }

    public static void convertToZap(LivingEntity entity, LivingEntity target) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (target instanceof Zombie) {
                Zap zap;
                Zombie zombie = (Zombie)target;
                if (!target.getType().is(RCEntityTypeTags.IMMORTAL_CANNOT_CONVERT) && (zap = (Zap)zombie.convertTo(RCEntityTypes.ZAP.get(), true)) != null) {
                    zap.finalizeSpawn((ServerLevelAccessor)level2, level2.getCurrentDifficultyAt(zap.blockPosition()), MobSpawnType.CONVERSION, null);
                    if (!entity.isSilent()) {
                        level2.levelEvent(null, 1026, entity.blockPosition(), 0);
                    }
                }
            }
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.ZAP_HEAD.get());
    }
}

