/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.swampy;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Swampy
extends Zombie {
    public Swampy(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.xpReward = 4;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    protected void addBehaviourGoals() {
        super.addBehaviourGoals();
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        if (hurt && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 140 * (int)modifier), (Entity)this);
            living.addEffect(new MobEffectInstance(MobEffects.POISON, 140 * (int)modifier), (Entity)this);
        }
        if (hurt && this.isBaby()) {
            this.kill();
        }
        return hurt;
    }

    public void travel(Vec3 travelVector) {
        if (this.isEffectiveAi() && this.isInWaterOrBubble()) {
            this.moveRelative(0.025f, travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.9f));
        } else {
            super.travel(travelVector);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void die(DamageSource source) {
        super.die(source);
        if (!this.level().isClientSide && (this.random.nextFloat() <= 0.8f || this.isBaby())) {
            this.spawnLingeringCloud();
            if (this.isBaby()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)14);
            }
        }
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        cloud.setRadius(2.5f);
        cloud.setRadiusOnUse(-0.5f);
        cloud.setWaitTime(10);
        cloud.setDuration(cloud.getDuration() / 2);
        cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
        cloud.addEffect(new MobEffectInstance(MobEffects.POISON, 200));
        this.level().addFreshEntity((Entity)cloud);
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 14) {
            this.createPoisonExplosion();
        }
    }

    private void createPoisonExplosion() {
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        for (int i = 0; i < 10; ++i) {
            double motionX = this.random.nextGaussian() * 0.2;
            double motionY = this.random.nextGaussian() * 0.2;
            double motionZ = this.random.nextGaussian() * 0.2;
            for (int j = 0; j < 20; ++j) {
                double xzAngle = this.random.nextDouble() * Math.PI * 2.0;
                double yAngle = this.random.nextDouble() * Math.PI / 2.0;
                double motionXDir = Math.cos(xzAngle) * Math.sin(yAngle);
                double motionYDir = Math.cos(yAngle);
                double motionZDir = Math.sin(xzAngle) * Math.sin(yAngle);
                this.level().addParticle((ParticleOptions)ParticleTypes.SQUID_INK, posX, posY, posZ, motionX + motionXDir * 0.1, motionY + motionYDir * 0.1, motionZ + motionZDir * 0.1);
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.random.nextInt(10) == 0) {
            this.level().addParticle((ParticleOptions)(this.random.nextBoolean() ? new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.BROWN_CONCRETE_POWDER.defaultBlockState()) : new BlockParticleOption(ParticleTypes.FALLING_DUST, Blocks.GREEN_CONCRETE_POWDER.defaultBlockState())), this.getRandomX(0.5), this.getRandomY() - 0.5, this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean canBeAffected(MobEffectInstance instance) {
        return instance.getEffect() != MobEffects.POISON && super.canBeAffected(instance);
    }

    protected SoundEvent getAmbientSound() {
        return RCSoundEvents.SWAMPY_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return RCSoundEvents.SWAMPY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return RCSoundEvents.SWAMPY_DEATH.get();
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.SWAMPY_HEAD.get());
    }

    public static boolean checkSwampySpawnRules(EntityType<Swampy> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Swampy.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.canSeeSky(pos));
    }
}

