/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.scarab;

import com.github.teamfusion.rottencreatures.common.level.entities.scarab.Scarab;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ScarabFlyingGoal
extends Goal {
    private final Scarab scarab;
    private int circlingTime = 0;
    private boolean clockwise = false;

    public ScarabFlyingGoal(Scarab scarab) {
        this.scarab = scarab;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.scarab.isFlying() && this.scarab.getTarget() != null;
    }

    public boolean canContinueToUse() {
        return this.scarab.isFlying() && this.scarab.getTarget() != null && this.scarab.getTarget().isAlive();
    }

    public void start() {
        this.circlingTime = 0;
        this.clockwise = this.scarab.getRandom().nextBoolean();
    }

    public void tick() {
        LivingEntity target = this.scarab.getTarget();
        if (target == null) {
            return;
        }
        ++this.circlingTime;
        if (this.circlingTime % 60 == 0 && this.scarab.getRandom().nextInt(4) == 0) {
            this.scarab.getMoveControl().setWantedPosition(target.getX(), target.getY(), target.getZ(), 1.5);
        } else {
            double circleRadius = 4.0;
            double angle = (double)this.circlingTime * 0.1 * (double)(this.clockwise ? 1 : -1);
            double offsetX = Math.cos(angle) * circleRadius;
            double offsetZ = Math.sin(angle) * circleRadius;
            Vec3 circlePos = new Vec3(target.getX() + offsetX, target.getY() + 2.0 + this.scarab.getRandom().nextDouble(), target.getZ() + offsetZ);
            this.scarab.getMoveControl().setWantedPosition(circlePos.x, circlePos.y, circlePos.z, 1.0);
        }
    }
}

