/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.immortal;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.level.entities.zap.Zap;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCMobEffects;
import com.github.teamfusion.rottencreatures.core.data.tags.RCEntityTypeTags;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Immortal
extends SpellcasterZombie {
    public static final EntityDataAccessor<Boolean> DASH = SynchedEntityData.defineId(Immortal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Immortal(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.xpReward = 30;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.FOLLOW_RANGE, 50.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ARMOR, 2.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DASH, (Object)false);
    }

    public boolean isDashing() {
        return (Boolean)this.getEntityData().get(DASH);
    }

    public void setDashing(boolean dashing) {
        this.getEntityData().set(DASH, (Object)dashing);
    }

    public boolean isBaby() {
        return false;
    }

    public void setBaby(boolean baby) {
    }

    protected void addBehaviourGoals() {
        super.addBehaviourGoals();
        this.goalSelector.addGoal(1, (Goal)new SpellcasterZombie.CastingSpellGoal());
        this.goalSelector.addGoal(5, (Goal)new SummonLightningGoal());
        this.goalSelector.addGoal(7, (Goal)new DashingGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<Zombie>(this, (Mob)this, Zombie.class, true){

            public boolean canUse() {
                return super.canUse() && this.target != null && !this.target.getType().is(RCEntityTypeTags.IMMORTAL_IGNORE);
            }
        });
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if ((this.tickCount + this.getId()) % 1200 == 0) {
            boolean shouldApplyEffect;
            Holder effect = MobEffects.DAMAGE_BOOST;
            List zaps = this.level().getEntitiesOfClass(Zap.class, this.getBoundingBox().inflate(16.0, 4.0, 16.0));
            int size = Math.max(0, zaps.size() - 1);
            boolean bl = shouldApplyEffect = !this.hasEffect(effect) || this.getEffect(effect).getAmplifier() < size || this.getEffect(effect).getDuration() < 600;
            if (this.hasPower() && !zaps.isEmpty() && shouldApplyEffect) {
                this.addEffect(new MobEffectInstance(effect, 1200, size));
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && !this.isNoAi()) {
            LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
            if (this.isInWaterOrBubble() && bolt != null) {
                bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)this.blockPosition().offset(0, 1, 0)));
                this.level().addFreshEntity((Entity)bolt);
                this.discard();
            }
        }
        if (this.isDashing()) {
            this.checkAutoSpinAttack(this.getBoundingBox(), this.getBoundingBox());
        }
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurt = super.doHurtTarget(entity);
        if (hurt && (this.getMainHandItem().isEmpty() || this.isDashing()) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.level().playSound(null, this.blockPosition(), RCSoundEvents.IMMORTAL_ELECTROSHOCK.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            living.addEffect(new MobEffectInstance((Holder)RCMobEffects.CHANNELLED.getHolder().get(), 140 * (int)modifier), (Entity)this);
            Zap.convertToZap((LivingEntity)this, living);
            if (this.isDashing()) {
                entity.hurt(this.damageSources().mobAttack((LivingEntity)this), 16.0f);
            }
        }
        return hurt;
    }

    protected void doPush(Entity entity) {
        super.doPush(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Zap.convertToZap((LivingEntity)this, living);
        }
        if (this.isDashing()) {
            this.doHurtTarget(entity);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source == this.damageSources().lightningBolt()) {
            this.restoreHealth();
            return false;
        }
        if (source == this.damageSources().cactus() || Objects.equals(source.getMsgId(), "arrow")) {
            return false;
        }
        if (this.hasPower()) {
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100));
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60, 2));
        }
        return super.hurt(source, amount);
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, source, recentlyHit);
        if (recentlyHit) {
            ItemStack stack = new ItemStack((ItemLike)Items.TRIDENT);
            stack.setDamageValue(stack.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(stack.getMaxDamage() - 3, 1))));
            HolderLookup.RegistryLookup enchantments = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            if (this.hasPower()) {
                if (this.random.nextFloat() <= 0.75f) {
                    stack.enchant(this.random.nextBoolean() ? (Holder)enchantments.get(Enchantments.CHANNELING).orElseThrow() : (Holder)enchantments.get(Enchantments.RIPTIDE).orElseThrow(), 1);
                }
                this.spawnAtLocation(stack);
            }
            if (!this.hasPower() && this.random.nextFloat() <= 0.1f) {
                this.spawnAtLocation(stack);
            }
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.IMMORTAL_HEAD.get());
    }

    public boolean hasPower() {
        return this.level().isThundering();
    }

    public void restoreHealth() {
        this.setHealth(this.getMaxHealth());
        this.level().playSound(null, this.blockPosition(), RCSoundEvents.IMMORTAL_HEAL.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
    }

    protected SoundEvent getAmbientSound() {
        return this.isAggressive() ? RCSoundEvents.IMMORTAL_ANGRY.get() : RCSoundEvents.IMMORTAL_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return RCSoundEvents.IMMORTAL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return RCSoundEvents.IMMORTAL_DEATH.get();
    }

    class SummonLightningGoal
    extends SpellcasterZombie.UseSpellGoal {
        SummonLightningGoal() {
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel level = (ServerLevel)Immortal.this.level();
            if (Immortal.this.random.nextBoolean()) {
                for (int i = 0; i <= Immortal.this.random.nextInt(2); ++i) {
                    BlockPos pos = Immortal.this.blockPosition().offset(-4 + Immortal.this.random.nextInt(9), 0, -4 + Immortal.this.random.nextInt(9));
                    LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
                    if (bolt == null) continue;
                    bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                    level.addFreshEntity((Entity)bolt);
                }
            }
        }

        @Override
        public boolean canUse() {
            return Immortal.this.getHealth() <= Immortal.this.getMaxHealth() / 100.0f * 80.0f && Immortal.this.hasPower() && Immortal.this.level().canSeeSky(Immortal.this.blockPosition()) && Immortal.this.random.nextBoolean();
        }

        @Override
        protected int getCastingTime() {
            return 0;
        }

        @Override
        protected int getCastingInterval() {
            return Immortal.this.getHealth() <= Immortal.this.getMaxHealth() / 100.0f * 40.0f ? 800 : 1600;
        }
    }

    class DashingGoal
    extends SpellcasterZombie.UseSpellGoal {
        private final Immortal immortal;

        DashingGoal(Immortal immortal) {
            this.immortal = immortal;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        @Override
        public void start() {
            super.start();
            this.immortal.setDashing(true);
        }

        @Override
        protected void performSpellCasting() {
            float zRot = this.immortal.getYHeadRot();
            float xRot = this.immortal.getXRot();
            float modifier = (float)Math.PI / 180;
            float x = -Mth.sin((float)(zRot * modifier)) * Mth.cos((float)(xRot * modifier));
            float y = -Mth.sin((float)(xRot * modifier));
            float z = Mth.cos((float)(zRot * modifier)) * Mth.cos((float)(xRot * modifier));
            float range = Mth.sqrt((float)(x * x + y * y + z * z));
            float power = 4.0f;
            this.immortal.push(x *= power / range, y *= power / range, z *= power / range);
            this.immortal.autoSpinAttackTicks = 30;
            if (!this.immortal.level().isClientSide) {
                this.immortal.setLivingEntityFlag(4, true);
            }
            if (this.immortal.onGround()) {
                this.immortal.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            this.immortal.level().playSound(null, (Entity)this.immortal, (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_3.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.immortal.level().playSound(null, (Entity)this.immortal, SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
        }

        @Override
        public void tick() {
            super.tick();
            Immortal.this.checkAutoSpinAttack(Immortal.this.getBoundingBox(), Immortal.this.getBoundingBox());
        }

        public void stop() {
            super.stop();
            this.immortal.setDashing(false);
            this.immortal.restoreHealth();
        }

        @Override
        public boolean canUse() {
            LivingEntity target = this.immortal.getTarget() != null ? this.immortal.getTarget() : null;
            return target != null && this.immortal.distanceTo((Entity)target) > 8.0f && super.canUse() && this.immortal.hasPower();
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 640;
        }
    }
}

