/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blocks;

import com.github.teamfusion.rottencreatures.common.level.blockentities.TreasureChestBlockEntity;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TreasureChestBlock
extends BaseEntityBlock {
    private static final int MAX = 15;
    private static final int ROTATIONS = 16;
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private static final VoxelShape SHAPE = TreasureChestBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return TreasureChestBlock.simpleCodec(TreasureChestBlock::new);
    }

    public TreasureChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ROTATION, (Comparable)Integer.valueOf(0))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TreasureChestBlockEntity) {
            CustomData customData;
            TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
            if (placer instanceof Player) {
                Player player = (Player)placer;
                chest.setOwnerUUID(player.getUUID());
            }
            if ((customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) == null || customData.isEmpty()) {
                return;
            }
            CompoundTag tag = customData.copyTag();
            if (tag.contains("Items", 9)) {
                ListTag itemsList = tag.getList("Items", 10);
                for (int i = 0; i < itemsList.size(); ++i) {
                    CompoundTag itemTag = itemsList.getCompound(i);
                    if (!itemTag.contains("id", 8)) continue;
                    try {
                        String id = itemTag.getString("id");
                        int count = itemTag.contains("Count", 3) ? itemTag.getInt("Count") : 1;
                        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id));
                        ItemStack itemStack = new ItemStack((ItemLike)item, count);
                        if (itemTag.contains("tag", 10)) {
                            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemTag.getCompound("tag")));
                        }
                        if (itemStack.isEmpty()) continue;
                        chest.getItems().add((Object)itemStack);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                chest.recalculateTotalCount();
            }
            if (chest.getOwnerUUID() == null && tag.hasUUID("OwnerUUID")) {
                chest.setOwnerUUID(tag.getUUID("OwnerUUID"));
            }
            chest.setChanged();
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return TreasureChestBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!TreasureChestBlock.canSupportCenter((LevelReader)context.getLevel(), (BlockPos)context.getClickedPos().below(), (Direction)Direction.UP)) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(Mth.floor((double)((double)(context.getRotation() * 16.0f / 360.0f) + 0.5)) & 0xF))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof TreasureChestBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
        if (!chest.isOwner(player.getUUID())) {
            UUID ownerUUID = chest.getOwnerUUID();
            if (ownerUUID != null && level.getServer() != null) {
                String ownerName = level.getServer().getProfileCache().get(ownerUUID).map(GameProfile::getName).orElse("someone");
                player.displayClientMessage((Component)Component.translatable((String)"block.rottencreatures.treasure_chest.cannot_open", (Object[])new Object[]{Component.literal((String)ownerName).withStyle(ChatFormatting.GOLD)}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"block.rottencreatures.treasure_chest.locked"), true);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean isOpen = (Boolean)state.getValue((Property)OPEN);
        if (!isOpen) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
            level.playSound(null, pos, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            if (chest.hasContents()) {
                NonNullList<ItemStack> storedItems = chest.removeAllItems();
                for (ItemStack items : storedItems) {
                    this.spawnItemEntity(level, pos, items);
                }
            }
        } else {
            if (!stack.isEmpty()) {
                BlockItem block;
                Item item = stack.getItem();
                if (item instanceof BlockItem && !(block = (BlockItem)item).canFitInsideContainerItems()) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                int amountToAdd = TreasureChestBlock.addItemsToContainer(chest, stack);
                NonNullList<ItemStack> replacedItems = chest.addItemsWithReplacement(stack.copy(), amountToAdd);
                for (ItemStack replacedItem : replacedItems) {
                    this.spawnItemEntity(level, pos, replacedItem);
                }
                stack.shrink(amountToAdd);
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                return ItemInteractionResult.CONSUME;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
            level.playSound(null, pos, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
        player.awardStat(Stats.OPEN_CHEST);
        return ItemInteractionResult.CONSUME;
    }

    private static int addItemsToContainer(TreasureChestBlockEntity chest, ItemStack heldItem) {
        NonNullList<ItemStack> items = chest.getItems();
        int totalCount = 0;
        for (ItemStack item : items) {
            totalCount += item.getCount();
        }
        int maxStackSize = chest.maxStackSize;
        int spaceLeft = maxStackSize - totalCount;
        int amountToAdd = spaceLeft <= 0 ? heldItem.getCount() : Math.min(spaceLeft, heldItem.getCount());
        return amountToAdd;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        TreasureChestBlockEntity chest;
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof TreasureChestBlockEntity && (chest = (TreasureChestBlockEntity)blockEntity).hasContents()) {
            ItemStack drop = new ItemStack((ItemLike)this);
            CompoundTag customTag = new CompoundTag();
            ListTag itemsList = new ListTag();
            for (ItemStack stack : chest.getItems()) {
                if (stack.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putString("id", BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
                itemTag.putInt("Count", stack.getCount());
                CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
                if (data != null && !data.isEmpty()) {
                    itemTag.put("tag", (Tag)data.copyTag());
                }
                itemsList.add((Object)itemTag);
            }
            if (!itemsList.isEmpty()) {
                customTag.put("Items", (Tag)itemsList);
            }
            if (chest.getOwnerUUID() != null) {
                customTag.putUUID("OwnerUUID", chest.getOwnerUUID());
            }
            if (!customTag.isEmpty()) {
                drop.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customTag));
            }
            return Collections.singletonList(drop);
        }
        return super.getDrops(state, builder);
    }

    private void spawnItemEntity(Level level, BlockPos pos, ItemStack stack) {
        if (!stack.isEmpty()) {
            BlockState state = level.getBlockState(pos);
            int rotation = (Integer)state.getValue((Property)ROTATION);
            double angle = Math.toRadians(((float)rotation * 22.5f + 180.0f) % 360.0f);
            double offsetX = -Math.sin(angle) * 0.7;
            double offsetZ = Math.cos(angle) * 0.7;
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack);
            double speed = 0.1 + level.random.nextDouble() * 0.05;
            itemEntity.setDeltaMovement(offsetX * speed, 0.2 + level.random.nextDouble() * 0.1, offsetZ * speed);
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        TreasureChestBlockEntity chest;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TreasureChestBlockEntity && (chest = (TreasureChestBlockEntity)blockEntity).isOwner(player.getUUID())) {
            return super.getDestroyProgress(state, player, level, pos);
        }
        return 0.0f;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TreasureChestBlockEntity) {
            TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
            if ((player.isCreative() || chest.isOwner(player.getUUID())) && chest.hasContents()) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                CompoundTag customTag = new CompoundTag();
                if (!chest.getItems().isEmpty()) {
                    ListTag itemsList = new ListTag();
                    for (ItemStack stack : chest.getItems()) {
                        if (stack.isEmpty()) continue;
                        CompoundTag itemTag = new CompoundTag();
                        itemTag.putString("id", BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
                        itemTag.putInt("Count", stack.getCount());
                        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
                        if (data != null && !data.isEmpty()) {
                            itemTag.put("tag", (Tag)data.copyTag());
                        }
                        itemsList.add((Object)itemTag);
                    }
                    if (!itemsList.isEmpty()) {
                        customTag.put("Items", (Tag)itemsList);
                    }
                }
                if (chest.getOwnerUUID() != null) {
                    customTag.putUUID("OwnerUUID", chest.getOwnerUUID());
                }
                if (!customTag.isEmpty()) {
                    itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customTag));
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
                chest.removeAllItems();
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), 16)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ROTATION, OPEN});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos origin, BlockState state) {
        return new TreasureChestBlockEntity(origin, state);
    }
}

