/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blockentities;

import com.github.teamfusion.rottencreatures.common.registries.RCBlockEntityTypes;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TreasureChestBlockEntity
extends BlockEntity {
    public static final int MAX_ITEMS = 64;
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_OWNER_UUID = "OwnerUUID";
    public static final String TAG_MAX_STACK_SIZE = "MaxStackSize";
    private NonNullList<ItemStack> items = NonNullList.create();
    private int totalCount = 0;
    private UUID ownerUUID;
    public int maxStackSize = 64;

    public TreasureChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(RCBlockEntityTypes.TREASURE_CHEST.get(), blockPos, blockState);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.items.isEmpty()) {
            ListTag itemsList = new ListTag();
            for (ItemStack stack : this.items) {
                CompoundTag itemTag = new CompoundTag();
                stack.save(provider, (Tag)itemTag);
                itemsList.add((Object)itemTag);
            }
            tag.put(TAG_ITEMS, (Tag)itemsList);
        }
        if (this.ownerUUID != null) {
            tag.putUUID(TAG_OWNER_UUID, this.ownerUUID);
        }
        if (this.maxStackSize != 64) {
            tag.putInt(TAG_MAX_STACK_SIZE, this.maxStackSize);
        }
        tag.putInt("ItemCount", this.totalCount);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.create();
        if (tag.contains(TAG_ITEMS, 9)) {
            ListTag itemsList = tag.getList(TAG_ITEMS, 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTag = itemsList.getCompound(i);
                Optional stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemTag);
                stack.ifPresent(itemStack -> this.items.add(itemStack));
            }
        }
        if (tag.hasUUID(TAG_OWNER_UUID)) {
            this.ownerUUID = tag.getUUID(TAG_OWNER_UUID);
        }
        this.maxStackSize = tag.contains(TAG_MAX_STACK_SIZE, 3) && !this.items.isEmpty() ? tag.getInt(TAG_MAX_STACK_SIZE) : (!this.items.isEmpty() ? ((ItemStack)this.items.getFirst()).getMaxStackSize() : 64);
        this.recalculateTotalCount();
    }

    public void recalculateTotalCount() {
        this.totalCount = 0;
        for (ItemStack stack : this.items) {
            this.totalCount += stack.getCount();
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public boolean hasContents() {
        return !this.items.isEmpty() && this.totalCount != 0;
    }

    public NonNullList<ItemStack> addItemsWithReplacement(ItemStack stack, int count) {
        if (stack.isEmpty() || count <= 0) {
            return NonNullList.create();
        }
        NonNullList replacedItems = NonNullList.create();
        int itemMaxStackSize = stack.getMaxStackSize();
        if (this.items.isEmpty()) {
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            this.recalculateTotalCount();
            this.setChanged();
            return replacedItems;
        }
        if (((ItemStack)this.items.get(0)).getMaxStackSize() != itemMaxStackSize) {
            replacedItems.addAll(this.removeAllItems());
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            this.recalculateTotalCount();
            this.setChanged();
            return replacedItems;
        }
        int spaceLeft = this.maxStackSize - this.totalCount;
        int toAdd = Math.min(count, this.maxStackSize);
        if (spaceLeft >= toAdd) {
            int added = 0;
            for (int i = 0; i < this.items.size() && toAdd > 0; ++i) {
                int canAdd;
                ItemStack existingStack = (ItemStack)this.items.get(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)stack) || (canAdd = Math.min(toAdd, existingStack.getMaxStackSize() - existingStack.getCount())) <= 0) continue;
                existingStack.grow(canAdd);
                toAdd -= canAdd;
                added += canAdd;
            }
            this.totalCount += added;
            if (toAdd > 0) {
                this.addItem(stack, toAdd);
            }
            this.setChanged();
        } else {
            ItemStack removedPortion;
            int canRemove;
            ItemStack oldStack;
            int itemsToReplaceCount = toAdd - spaceLeft;
            int currentReplacedCount = 0;
            NonNullList actuallyReplaced = NonNullList.create();
            int i = 0;
            while (i < this.items.size() && currentReplacedCount < itemsToReplaceCount) {
                oldStack = (ItemStack)this.items.get(i);
                if (ItemStack.isSameItemSameComponents((ItemStack)oldStack, (ItemStack)stack)) {
                    ++i;
                    continue;
                }
                canRemove = Math.min(oldStack.getCount(), itemsToReplaceCount - currentReplacedCount);
                removedPortion = oldStack.split(canRemove);
                actuallyReplaced.add((Object)removedPortion);
                currentReplacedCount += canRemove;
                this.totalCount -= canRemove;
                if (oldStack.isEmpty()) {
                    this.items.remove(i);
                    continue;
                }
                ++i;
            }
            i = 0;
            while (i < this.items.size() && currentReplacedCount < itemsToReplaceCount) {
                oldStack = (ItemStack)this.items.get(i);
                canRemove = Math.min(oldStack.getCount(), itemsToReplaceCount - currentReplacedCount);
                removedPortion = oldStack.split(canRemove);
                actuallyReplaced.add((Object)removedPortion);
                currentReplacedCount += canRemove;
                this.totalCount -= canRemove;
                if (oldStack.isEmpty()) {
                    this.items.remove(i);
                    continue;
                }
                ++i;
            }
            int added = 0;
            for (int i2 = 0; i2 < this.items.size() && toAdd > 0; ++i2) {
                int canAdd;
                ItemStack existingStack = (ItemStack)this.items.get(i2);
                if (!ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)stack) || (canAdd = Math.min(toAdd, existingStack.getMaxStackSize() - existingStack.getCount())) <= 0) continue;
                existingStack.grow(canAdd);
                toAdd -= canAdd;
                added += canAdd;
            }
            this.totalCount += added;
            if (toAdd > 0) {
                this.addItem(stack, toAdd);
            }
            replacedItems.addAll((Collection)actuallyReplaced);
            this.setChanged();
        }
        this.items.removeIf(ItemStack::isEmpty);
        this.recalculateTotalCount();
        return replacedItems;
    }

    private void addItem(ItemStack stack, int count) {
        int stackSize;
        if (stack.isEmpty() || count <= 0) {
            return;
        }
        int itemMaxStackSize = stack.getMaxStackSize();
        for (int toAdd = count; toAdd > 0; toAdd -= stackSize) {
            ItemStack newStack = stack.copy();
            stackSize = Math.min(toAdd, itemMaxStackSize);
            newStack.setCount(stackSize);
            this.items.add((Object)newStack);
            this.totalCount += stackSize;
        }
        this.setChanged();
    }

    public NonNullList<ItemStack> removeAllItems() {
        NonNullList result = NonNullList.create();
        result.addAll(this.items);
        this.items.clear();
        this.totalCount = 0;
        this.maxStackSize = 64;
        this.setChanged();
        return result;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
        this.setChanged();
    }

    public boolean isOwner(UUID playerUUID) {
        return this.ownerUUID != null && this.ownerUUID.equals(playerUUID);
    }
}

