/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.entities.renderer.immortal;

import com.github.teamfusion.rottencreatures.client.level.entities.model.ImmortalModel;
import com.github.teamfusion.rottencreatures.common.level.entities.immortal.Immortal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class ImpaledLayer<T extends Immortal>
extends RenderLayer<T, ImmortalModel<T>> {
    private final TridentModel trident;

    public ImpaledLayer(RenderLayerParent<T, ImmortalModel<T>> parent, EntityModelSet modelSet) {
        super(parent);
        this.trident = new TridentModel(modelSet.bakeLayer(ModelLayers.TRIDENT));
    }

    public void render(PoseStack matrices, MultiBufferSource source, int light, T entity, float angle, float distance, float tickDelta, float animationProgress, float yaw, float pitch) {
        matrices.pushPose();
        matrices.translate(0.0f, 0.5f, -0.75f);
        matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
        VertexConsumer vertices = ItemRenderer.getFoilBufferDirect((MultiBufferSource)source, (RenderType)this.trident.renderType(ResourceLocation.withDefaultNamespace((String)"textures/entity/trident.png")), (boolean)false, (boolean)((Immortal)((Object)entity)).hasPower());
        this.trident.renderToBuffer(matrices, vertices, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }
}

