/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.entities.model;

import com.github.teamfusion.rottencreatures.common.level.entities.deadbeard.DeadBeard;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DeadBeardModel<T extends DeadBeard>
extends HumanoidModel<T> {
    public DeadBeardModel(ModelPart modelPart) {
        super(modelPart);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 17).addBox(-8.0f, -18.0f, -6.0f, 16.0f, 18.0f, 12.0f).texOffs(0, 47).addBox(-8.5f, -18.5f, -6.5f, 17.0f, 22.0f, 13.0f).texOffs(61, 47).addBox(-7.5f, -19.0f, -7.0f, 15.0f, 9.0f, 9.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        root.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 8.0f).texOffs(56, 16).mirror().addBox(-3.5f, -8.5f, -3.5f, 7.0f, 8.0f, 7.0f).texOffs(32, 0).mirror().addBox(-3.0f, -13.0f, -4.5f, 6.0f, 7.0f, 9.0f).texOffs(62, 3).mirror().addBox(3.0f, -10.0f, -4.5f, 3.0f, 4.0f, 9.0f).texOffs(62, 3).addBox(-6.0f, -10.0f, -4.5f, 3.0f, 4.0f, 9.0f).texOffs(88, 6).mirror().addBox(-4.0f, 0.0f, -4.0f, 8.0f, 6.0f, 0.0f).texOffs(2, 3).addBox(-6.0f, -5.0f, -4.0f, 2.0f, 5.0f, 0.0f).texOffs(2, 3).mirror().addBox(4.0f, -5.0f, -4.0f, 2.0f, 5.0f, 0.0f), PartPose.offset((float)0.0f, (float)-15.0f, (float)-5.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(60, 65).addBox(-2.5f, -2.0f, -2.5f, 5.0f, 13.0f, 5.0f).texOffs(80, 75).addBox(-3.0f, 6.0f, -3.0f, 6.0f, 2.0f, 6.0f), PartPose.offset((float)-10.5f, (float)-16.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(60, 65).mirror().addBox(-2.5f, -2.0f, -2.5f, 5.0f, 13.0f, 5.0f).texOffs(80, 75).mirror().addBox(-3.0f, 6.0f, -3.0f, 6.0f, 2.0f, 6.0f), PartPose.offset((float)10.5f, (float)-16.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(56, 31).addBox(-2.5f, 0.0f, -3.0f, 5.0f, 11.0f, 5.0f), PartPose.offset((float)-5.5f, (float)13.0f, (float)0.5f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(76, 35).mirror().addBox(-2.5f, 0.0f, -3.0f, 5.0f, 7.0f, 5.0f).texOffs(96, 41).mirror().addBox(-1.0f, 7.0f, -1.5f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)5.5f, (float)13.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)109, (int)125);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        super.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.body.y = 13.0f;
        this.head.y = -2.0f;
        this.rightArm.setPos(-10.5f, -3.0f, 0.0f);
        this.leftArm.setPos(10.5f, -3.0f, 0.0f);
        this.rightLeg.y = 13.0f;
        this.leftLeg.y = 13.0f;
        if (((DeadBeard)((Object)entity)).isIgnited()) {
            this.rightArm.setRotation(-135.0f, 0.0f, 0.0f);
            this.leftArm.setRotation(-135.0f, 0.0f, 0.0f);
        } else {
            this.animateZombieArms(this.leftArm, this.rightArm, entity.isAggressive(), this.attackTime, animationProgress);
        }
    }

    private void animateZombieArms(ModelPart leftArm, ModelPart rightArm, boolean isAggressive, float attackTime, float animProgress) {
        float j = (float)(-Math.PI) / (isAggressive ? 3.5f : 10.0f);
        float h = Mth.sin((float)(attackTime * (float)Math.PI));
        float i = Mth.sin((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
        rightArm.zRot = 0.0f;
        leftArm.zRot = 0.0f;
        rightArm.yRot = -(0.1f - h * 0.6f);
        leftArm.yRot = 0.1f - h * 0.6f;
        rightArm.xRot = j;
        leftArm.xRot = j;
        rightArm.xRot += h * 1.2f - i * 0.4f;
        leftArm.xRot += h * 1.2f - i * 0.4f;
        AnimationUtils.bobArms((ModelPart)rightArm, (ModelPart)leftArm, (float)animProgress);
    }
}

