/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.blockentities.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ImmortalSkullModel
extends SkullModelBase {
    private final ModelPart root;
    private final ModelPart head;

    public ImmortalSkullModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
    }

    public static LayerDefinition createMobHeadLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(59, 40).addBox(0.0f, -3.5f, 0.0f, 2.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)4.0f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(43, 40).addBox(-2.0f, -4.5f, 0.0f, 2.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-3.5f, (float)-1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        head.addOrReplaceChild("head_r3", CubeListBuilder.create().texOffs(48, 35).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("overlay", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(float animation, float yRot, float xRot) {
        this.head.yRot = yRot * ((float)Math.PI / 180);
        this.head.xRot = xRot * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.render(matrices, buffer, packedLight, packedOverlay, color);
    }
}

