/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventoryHelper {
    private static final List<Function<Player, IItemHandler>> PLAYER_INVENTORY_PROVIDERS = new ArrayList<Function<Player, IItemHandler>>();
    private static final List<Function<Player, IItemHandler>> PLAYER_EQUIPMENT_INVENTORY_PROVIDERS = new ArrayList<Function<Player, IItemHandler>>();

    private InventoryHelper() {
    }

    public static void registerEquipmentInventoryProvider(Function<Player, IItemHandler> provider) {
        PLAYER_EQUIPMENT_INVENTORY_PROVIDERS.add(provider);
    }

    public static void registerPlayerInventoryProvider(Function<Player, IItemHandler> provider) {
        PLAYER_INVENTORY_PROVIDERS.add(provider);
    }

    public static Optional<ItemStack> getItemFromEitherHand(Player player, Item item) {
        ItemStack mainHandItem = player.getMainHandItem();
        if (mainHandItem.getItem() == item) {
            return Optional.of(mainHandItem);
        }
        ItemStack offhandItem = player.getOffhandItem();
        if (offhandItem.getItem() == item) {
            return Optional.of(offhandItem);
        }
        return Optional.empty();
    }

    public static boolean hasItem(IItemHandler inventory, Predicate<ItemStack> matches) {
        AtomicBoolean result = new AtomicBoolean(false);
        InventoryHelper.iterate(inventory, (slot, stack) -> {
            if (!stack.isEmpty() && matches.test((ItemStack)stack)) {
                result.set(true);
            }
        }, result::get);
        return result.get();
    }

    public static Set<Integer> getItemSlots(IItemHandler inventory, Predicate<ItemStack> matches) {
        HashSet<Integer> slots = new HashSet<Integer>();
        InventoryHelper.iterate(inventory, (slot, stack) -> {
            if (!stack.isEmpty() && matches.test((ItemStack)stack)) {
                slots.add((Integer)slot);
            }
        });
        return slots;
    }

    public static void copyTo(IItemHandlerModifiable handlerA, IItemHandlerModifiable handlerB) {
        int slotsA = handlerA.getSlots();
        int slotsB = handlerB.getSlots();
        for (int slot = 0; slot < slotsA && slot < slotsB; ++slot) {
            ItemStack slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.isEmpty()) continue;
            handlerB.setStackInSlot(slot, slotStack);
        }
    }

    public static List<ItemStack> insertIntoInventory(List<ItemStack> stacks, IItemHandler inventory, boolean simulate) {
        if (stacks.isEmpty()) {
            return stacks;
        }
        IItemHandler targetInventory = inventory;
        if (simulate) {
            targetInventory = InventoryHelper.cloneInventory(inventory);
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            ItemStack result = InventoryHelper.insertIntoInventory(stack, targetInventory, false);
            if (result.isEmpty()) continue;
            remaining.add(result);
        }
        return remaining;
    }

    public static IItemHandler cloneInventory(IItemHandler inventory) {
        ItemStackHandler cloned = new ItemStackHandler(inventory.getSlots());
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            cloned.insertItem(slot, inventory.getStackInSlot(slot).copy(), false);
        }
        return cloned;
    }

    public static ItemStack insertIntoInventory(ItemStack stack, IItemHandler inventory, boolean simulate) {
        if (inventory instanceof IItemHandlerSimpleInserter) {
            IItemHandlerSimpleInserter itemHandlerSimpleInserter = (IItemHandlerSimpleInserter)inventory;
            return itemHandlerSimpleInserter.insertItem(stack, simulate);
        }
        ItemStack remainingStack = stack.copy();
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && !remainingStack.isEmpty(); ++slot) {
            remainingStack = inventory.insertItem(slot, remainingStack, simulate);
        }
        return remainingStack;
    }

    public static ItemStack insertIntoInventoryMatchingFirst(ItemStack stack, IItemHandler inventory, boolean simulate) {
        ItemStack slotStack;
        int slot;
        ItemStack remainingStack = stack.copy();
        int slots = inventory.getSlots();
        for (slot = 0; slot < slots && !remainingStack.isEmpty(); ++slot) {
            slotStack = inventory.getStackInSlot(slot);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remainingStack)) continue;
            remainingStack = inventory.insertItem(slot, remainingStack, simulate);
        }
        for (slot = 0; slot < slots && !remainingStack.isEmpty(); ++slot) {
            slotStack = inventory.getStackInSlot(slot);
            if (!slotStack.isEmpty()) continue;
            remainingStack = inventory.insertItem(slot, remainingStack, simulate);
        }
        return remainingStack;
    }

    public static ItemStack extractFromInventory(Item item, int count, IItemHandler inventory, boolean simulate) {
        return InventoryHelper.extractFromInventory((ItemStack stack) -> stack.getItem() == item, count, inventory, simulate);
    }

    public static ItemStack extractFromInventory(Predicate<ItemStack> stackMatcher, int count, IItemHandler inventory, boolean simulate) {
        ItemStack ret = ItemStack.EMPTY;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && ret.getCount() < count; ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (!stackMatcher.test(slotStack) || !ret.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)ret, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.getCount(), count - ret.getCount());
            ItemStack extractedStack = inventory.extractItem(slot, toExtract, simulate);
            if (ret.isEmpty()) {
                ret = extractedStack;
                continue;
            }
            ret.setCount(ret.getCount() + extractedStack.getCount());
        }
        return ret;
    }

    public static ItemStack extractFromInventory(ItemStack stack, IItemHandler inventory, boolean simulate) {
        int extractedCount = 0;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && extractedCount < stack.getCount(); ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.getCount(), stack.getCount() - extractedCount);
            extractedCount += inventory.extractItem(slot, toExtract, simulate).getCount();
        }
        if (extractedCount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack result = stack.copy();
        result.setCount(extractedCount);
        return result;
    }

    public static ItemStack runPickupOnPickupResponseUpgrades(Level level, UpgradeHandler upgradeHandler, ItemStack remainingStack, boolean simulate) {
        return InventoryHelper.runPickupOnPickupResponseUpgrades(level, null, upgradeHandler, remainingStack, simulate);
    }

    public static ItemStack runPickupOnPickupResponseUpgrades(Level level, @Nullable Player player, UpgradeHandler upgradeHandler, ItemStack remainingStack, boolean simulate) {
        List<IPickupResponseUpgrade> pickupUpgrades = upgradeHandler.getWrappersThatImplement(IPickupResponseUpgrade.class);
        for (IPickupResponseUpgrade pickupUpgrade : pickupUpgrades) {
            int countBeforePickup = remainingStack.getCount();
            Item item = remainingStack.getItem();
            remainingStack = pickupUpgrade.pickup(level, remainingStack, simulate);
            if (!simulate && player != null && remainingStack.getCount() != countBeforePickup) {
                InventoryHelper.playPickupSound(level, player);
                player.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), countBeforePickup - remainingStack.getCount());
            }
            if (!remainingStack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return remainingStack;
    }

    private static void playPickupSound(Level level, @Nonnull Player player) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, RandHelper.getRandomMinusOneToOne(level.random) * 1.4f + 2.0f);
    }

    public static void iterate(IItemHandler handler, BiConsumer<Integer, ItemStack> actOn) {
        InventoryHelper.iterate(handler, actOn, () -> false);
    }

    public static void iterate(IItemHandler handler, BiConsumer<Integer, ItemStack> actOn, BooleanSupplier shouldExit) {
        InventoryHelper.iterate(handler, actOn, shouldExit, true);
    }

    public static void iterate(IItemHandler handler, BiConsumer<Integer, ItemStack> actOn, BooleanSupplier shouldExit, boolean getVirtualCounts) {
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack itemStack;
            if (!getVirtualCounts && handler instanceof InventoryHandler) {
                InventoryHandler inventoryHandler = (InventoryHandler)handler;
                itemStack = inventoryHandler.getSlotStack(slot);
            } else {
                itemStack = handler.getStackInSlot(slot);
            }
            ItemStack stack = itemStack;
            actOn.accept(slot, stack);
            if (shouldExit.getAsBoolean()) break;
        }
    }

    public static int getCountMissingInHandler(IItemHandler itemHandler, ItemStack filter, int expectedCount) {
        MutableInt missingCount = new MutableInt(expectedCount);
        InventoryHelper.iterate(itemHandler, (slot, stack) -> {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filter)) {
                missingCount.subtract(Math.min(stack.getCount(), missingCount.getValue()));
            }
        }, () -> missingCount.getValue() == 0);
        return missingCount.getValue();
    }

    public static <T> T iterate(IItemHandler handler, BiFunction<Integer, ItemStack, T> getFromSlotStack, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        T ret = supplyDefault.get();
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            ret = getFromSlotStack.apply(slot, stack);
            if (shouldExit.test(ret)) break;
        }
        return ret;
    }

    public static void transfer(IItemHandler handlerA, IItemHandler handlerB, Consumer<Supplier<ItemStack>> onInserted) {
        int slotsA = handlerA.getSlots();
        block0: for (int slot = 0; slot < slotsA; ++slot) {
            ItemStack extractedStack;
            ItemStack slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.isEmpty()) continue;
            for (int countToTransfer = slotStack.getCount(); countToTransfer > 0; countToTransfer -= extractedStack.getCount()) {
                int toExtract;
                ItemStack toInsert = slotStack.copy();
                toInsert.setCount(Math.min(slotStack.getMaxStackSize(), countToTransfer));
                ItemStack remainingAfterInsert = InventoryHelper.insertIntoInventory(toInsert, handlerB, true);
                if (remainingAfterInsert.getCount() == toInsert.getCount() || (extractedStack = handlerA.extractItem(slot, toExtract = toInsert.getCount() - remainingAfterInsert.getCount(), true)).isEmpty()) continue block0;
                InventoryHelper.insertIntoInventory(handlerA.extractItem(slot, extractedStack.getCount(), false), handlerB, false);
                onInserted.accept(() -> {
                    ItemStack copiedStack = slotStack.copy();
                    copiedStack.setCount(extractedStack.getCount());
                    return copiedStack;
                });
            }
        }
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        int slots = itemHandler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (itemHandler.getStackInSlot(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getAndRemove(IItemHandler itemHandler, int slot) {
        if (slot >= itemHandler.getSlots()) {
            return ItemStack.EMPTY;
        }
        return itemHandler.extractItem(slot, itemHandler.getStackInSlot(slot).getCount(), false);
    }

    public static void insertOrDropItem(Player player, ItemStack stack, IItemHandler ... inventories) {
        ItemStack ret = stack;
        for (IItemHandler inventory : inventories) {
            if (!(ret = InventoryHelper.insertIntoInventory(ret, inventory, false)).isEmpty()) continue;
            return;
        }
        if (!ret.isEmpty()) {
            player.drop(ret, true);
        }
    }

    public static ItemStack mergeIntoPlayerInventory(Player player, ItemStack stack, int startSlot) {
        ItemStack result = stack.copy();
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int slot = startSlot; slot < player.getInventory().items.size(); ++slot) {
            ItemStack slotStack = player.getInventory().getItem(slot);
            if (slotStack.isEmpty()) {
                emptySlots.add(slot);
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)result)) continue;
            int count = Math.min(slotStack.getMaxStackSize() - slotStack.getCount(), result.getCount());
            slotStack.grow(count);
            result.shrink(count);
            if (!result.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        Iterator iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack slotStack = result.copy();
            slotStack.setCount(Math.min(slotStack.getMaxStackSize(), result.getCount()));
            player.getInventory().setItem(slot, slotStack);
            result.shrink(slotStack.getCount());
            if (!result.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return result;
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(IItemHandler handler) {
        return InventoryHelper.getCompactedStacks(handler, new HashSet<Integer>());
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(IItemHandler handler, Set<Integer> ignoreSlots) {
        return InventoryHelper.getCompactedStacks(handler, ignoreSlots, true);
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(IItemHandler handler, Set<Integer> ignoreSlots, boolean getVirtualCounts) {
        HashMap<ItemStackKey, Integer> ret = new HashMap<ItemStackKey, Integer>();
        InventoryHelper.iterate(handler, (Integer slot, ItemStack stack) -> {
            if (stack.isEmpty() || ignoreSlots.contains(slot)) {
                return;
            }
            ItemStackKey itemStackKey = ItemStackKey.of(stack);
            ret.put(itemStackKey, ret.computeIfAbsent(itemStackKey, fs -> 0) + stack.getCount());
        }, () -> false, getVirtualCounts);
        return ret;
    }

    public static List<ItemStack> getCompactedStacksSortedByCount(IItemHandler handler) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(InventorySorter.BY_COUNT);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        sortedList.forEach(e -> {
            ItemStack stackCopy = ((ItemStackKey)e.getKey()).getStack().copy();
            stackCopy.setCount(((Integer)e.getValue()).intValue());
            ret.add(stackCopy);
        });
        return ret;
    }

    public static List<ItemStack> getStacks(IItemHandler handler) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        InventoryHelper.iterate(handler, (slot, stack) -> ret.add((ItemStack)stack));
        return ret;
    }

    public static Set<ItemStackKey> getUniqueStacks(IItemHandler handler) {
        HashSet<ItemStackKey> uniqueStacks = new HashSet<ItemStackKey>();
        InventoryHelper.iterate(handler, (slot, stack) -> {
            if (stack.isEmpty()) {
                return;
            }
            ItemStackKey itemStackKey = ItemStackKey.of(stack);
            uniqueStacks.add(itemStackKey);
        });
        return uniqueStacks;
    }

    public static List<Integer> getEmptySlotsRandomized(IItemHandler inventory) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).isEmpty()) continue;
            list.add(i);
        }
        Collections.shuffle(list, new Random());
        return list;
    }

    public static void shuffleItems(List<ItemStack> stacks, int emptySlotsCount, RandomSource rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (itemstack.getCount() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (emptySlotsCount - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.nextInt((RandomSource)rand, (int)0, (int)(list.size() - 1)));
            int i = Mth.nextInt((RandomSource)rand, (int)1, (int)(itemstack2.getCount() / 2));
            ItemStack itemstack1 = itemstack2.split(i);
            if (itemstack2.getCount() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.getCount() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, new Random());
    }

    public static void dropItems(ItemStackHandler inventoryHandler, Level level, BlockPos pos) {
        InventoryHelper.dropItems(inventoryHandler, level, pos.getX(), pos.getY(), pos.getZ());
    }

    public static void dropItems(ItemStackHandler inventoryHandler, Level level, double x, double y, double z) {
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (Integer slot, ItemStack stack) -> InventoryHelper.dropItem(inventoryHandler, level, x, y, z, slot, stack), () -> false, false);
    }

    public static void dropItem(ItemStackHandler handler, Level level, double x, double y, double z, Integer slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        if (handler instanceof InventoryHandler) {
            int countToDrop;
            InventoryHandler inventoryHandler = (InventoryHandler)handler;
            for (int countToExtract = stack.getCount(); countToExtract > 0; countToExtract -= countToDrop) {
                countToDrop = Math.min(stack.getMaxStackSize(), countToExtract);
                Containers.dropItemStack((Level)level, (double)x, (double)y, (double)z, (ItemStack)stack.copyWithCount(countToDrop));
            }
            inventoryHandler.setSlotStack(slot, ItemStack.EMPTY);
        } else {
            ItemStack extractedStack = handler.extractItem(slot.intValue(), stack.getMaxStackSize(), false);
            while (!extractedStack.isEmpty()) {
                Containers.dropItemStack((Level)level, (double)x, (double)y, (double)z, (ItemStack)extractedStack);
                extractedStack = handler.extractItem(slot.intValue(), stack.getMaxStackSize(), false);
            }
            handler.setStackInSlot(slot.intValue(), ItemStack.EMPTY);
        }
    }

    public static int getAnalogOutputSignal(ITrackedContentsItemHandler handler) {
        AtomicDouble totalFilled = new AtomicDouble(0.0);
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        InventoryHelper.iterate((IItemHandler)handler, (slot, stack) -> {
            if (!stack.isEmpty()) {
                int slotLimit = handler.getSlotLimit((int)slot);
                totalFilled.addAndGet((double)((float)stack.getCount() / ((float)slotLimit / (64.0f / (float)stack.getMaxStackSize()))));
                isEmpty.set(false);
            }
        });
        double percentFilled = totalFilled.get() / (double)handler.getSlots();
        return Mth.floor((double)(percentFilled * 14.0)) + (isEmpty.get() ? 0 : 1);
    }

    public static List<IItemHandler> getItemHandlersFromPlayerIncludingContainers(Player player) {
        ArrayList<IItemHandler> itemHandlers = new ArrayList<IItemHandler>();
        PLAYER_INVENTORY_PROVIDERS.forEach(provider -> {
            IItemHandler itemHandler = (IItemHandler)provider.apply(player);
            itemHandlers.add(itemHandler);
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                IItemHandler containerHandler;
                ItemStack slotStack = itemHandler.getStackInSlot(slot);
                if (slotStack.isEmpty() || (containerHandler = (IItemHandler)slotStack.getCapability(Capabilities.ItemHandler.ITEM)) == null) continue;
                itemHandlers.add(containerHandler);
            }
        });
        return itemHandlers;
    }

    public static List<IItemHandler> getEquipmentItemHandlersFromPlayer(Player player) {
        ArrayList<IItemHandler> itemHandlers = new ArrayList<IItemHandler>();
        PLAYER_EQUIPMENT_INVENTORY_PROVIDERS.forEach(provider -> {
            IItemHandler itemHandler = (IItemHandler)provider.apply(player);
            itemHandlers.add(itemHandler);
        });
        return itemHandlers;
    }

    static {
        InventoryHelper.registerPlayerInventoryProvider(player -> (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY));
        InventoryHelper.registerEquipmentInventoryProvider(player -> new CombinedInvWrapper(new IItemHandlerModifiable[]{new PlayerArmorInvWrapper(player.getInventory()), new PlayerOffhandInvWrapper(player.getInventory()), new RangedWrapper((IItemHandlerModifiable)new InvWrapper((Container)player.getInventory()), player.getInventory().selected, player.getInventory().selected + 1)}));
    }
}

